/*
 * Decompiled with CFR 0.152.
 */
import com.ghgande.j2mod.modbus.ModbusException;
import com.ghgande.j2mod.modbus.facade.ModbusSerialMaster;
import com.ghgande.j2mod.modbus.procimg.Register;
import com.ghgande.j2mod.modbus.procimg.SimpleRegister;
import com.ghgande.j2mod.modbus.util.SerialParameters;
import java.io.IOException;
import java.nio.ByteBuffer;

public class TestModbus {
    private static final int NB_READ = 122;
    private static final int READ_ADDRESS = 8314;
    private static final int NB_WRITE = 10;
    private static final int WRITE_ADDRESS = 8225;

    private static void write(ModbusSerialMaster master) throws ModbusException {
        byte[] bytes = new byte[20];
        ByteBuffer bf = ByteBuffer.wrap(bytes);
        bf.put((byte)1);
        bf.put((byte)121);
        bf.put((byte)111);
        bf.put((byte)112);
        bf.put((byte)48);
        bf.put((byte)0);
        bf.put((byte)0);
        Register[] registers = new Register[10];
        System.out.println("------- write ---------");
        int i = 0;
        while (i < registers.length) {
            byte b1 = bytes[i * 2];
            byte b2 = bytes[i * 2 + 1];
            System.out.println(String.valueOf(i * 2) + ": " + b1 + "->" + (char)b1);
            System.out.println(String.valueOf(i * 2 + 1) + ": " + b2 + "->" + (char)b2);
            registers[i] = new SimpleRegister(b1, b2);
            ++i;
        }
        master.writeMultipleRegisters(1, 8225, registers);
    }

    private static void read(ModbusSerialMaster master) throws ModbusException {
        Register[] registers = master.readMultipleRegisters(1, 8314, 50);
        int i = 0;
        Register[] registerArray = registers;
        int n = registers.length;
        int n2 = 0;
        while (n2 < n) {
            Register register = registerArray[n2];
            byte[] bytes = register.toBytes();
            byte b1 = bytes[0];
            byte b2 = bytes[1];
            System.out.println(String.valueOf(i) + ": " + b1 + "->" + (char)b1);
            System.out.println(String.valueOf(++i) + ": " + b2 + "->" + (char)b2);
            ++i;
            ++n2;
        }
    }

    public static void main(String[] args) throws IOException {
        SerialParameters parameters = new SerialParameters("/dev/ttyUSB1", 19200, 0, 0, 8, 1, 0, false);
        parameters.setEncoding("rtu");
        ModbusSerialMaster mMaster = new ModbusSerialMaster(parameters);
        try {
            try {
                mMaster.connect();
                TestModbus.write(mMaster);
                Thread.sleep(500L);
                TestModbus.read(mMaster);
            }
            catch (Exception e) {
                e.printStackTrace();
                mMaster.disconnect();
            }
        }
        finally {
            mMaster.disconnect();
        }
    }
}

