/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.cmd;

import com.ghgande.j2mod.modbus.io.ModbusTCPTransaction;
import com.ghgande.j2mod.modbus.msg.ReadInputRegistersRequest;
import com.ghgande.j2mod.modbus.msg.ReadInputRegistersResponse;
import com.ghgande.j2mod.modbus.msg.WriteSingleRegisterRequest;
import com.ghgande.j2mod.modbus.net.TCPMasterConnection;
import com.ghgande.j2mod.modbus.procimg.SimpleRegister;
import java.net.InetAddress;

public class AIAOTest {
    private static void printUsage() {
        System.out.println("java com.ghgande.j2mod.modbus.cmd.AIAOTest <address{:<port>} [String]> <register a_in [int16]> <register a_out [int16]>");
    }

    public static void main(String[] args) {
        InetAddress addr = null;
        TCPMasterConnection con = null;
        ReadInputRegistersRequest ai_req = null;
        WriteSingleRegisterRequest ao_req = null;
        ModbusTCPTransaction ai_trans = null;
        ModbusTCPTransaction ao_trans = null;
        int ai_ref = 0;
        int ao_ref = 0;
        int port = 502;
        int unit_in = 0;
        int unit_out = 0;
        if (args.length < 3) {
            AIAOTest.printUsage();
            System.exit(1);
        }
        try {
            try {
                try {
                    String serverAddress = args[0];
                    String[] parts = serverAddress.split(":");
                    String address = parts[0];
                    if (parts.length > 1) {
                        port = Integer.parseInt(parts[1]);
                        if (parts.length > 2) {
                            unit_in = unit_out = Integer.parseInt(parts[2]);
                            if (parts.length > 3) {
                                unit_out = Integer.parseInt(parts[3]);
                            }
                        }
                    }
                    addr = InetAddress.getByName(address);
                    ai_ref = Integer.parseInt(args[1]);
                    ao_ref = Integer.parseInt(args[2]);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    AIAOTest.printUsage();
                    System.exit(1);
                }
                con = new TCPMasterConnection(addr);
                con.setPort(port);
                con.connect();
                System.out.println("Connected to " + addr.toString() + ":" + con.getPort());
                ai_req = new ReadInputRegistersRequest(ai_ref, 1);
                ao_req = new WriteSingleRegisterRequest();
                ao_req.setReference(ao_ref);
                ai_req.setUnitID(unit_in);
                ao_req.setUnitID(unit_out);
                ai_trans = new ModbusTCPTransaction(con);
                ai_trans.setRequest(ai_req);
                ao_trans = new ModbusTCPTransaction(con);
                ao_trans.setRequest(ao_req);
                SimpleRegister new_out = new SimpleRegister(0);
                ao_req.setRegister(new_out);
                int last_out = Integer.MIN_VALUE;
                while (true) {
                    ai_trans.execute();
                    int new_in = ((ReadInputRegistersResponse)ai_trans.getResponse()).getRegister(0).getValue();
                    if (new_in == last_out) continue;
                    new_out.setValue(new_in);
                    ao_trans.execute();
                    last_out = new_in;
                    System.out.println("Updated Output Register with value from Input Register.");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                con.close();
            }
        }
        catch (Throwable throwable) {
            con.close();
            throw throwable;
        }
    }
}

