/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.cmd;

import com.ghgande.j2mod.modbus.io.ModbusSerialTransport;
import com.ghgande.j2mod.modbus.io.ModbusTCPTransaction;
import com.ghgande.j2mod.modbus.io.ModbusTransaction;
import com.ghgande.j2mod.modbus.io.ModbusTransport;
import com.ghgande.j2mod.modbus.msg.ReadCoilsRequest;
import com.ghgande.j2mod.modbus.msg.ReadCoilsResponse;
import com.ghgande.j2mod.modbus.net.ModbusMasterFactory;

public class ReadCoilsTest {
    private static void printUsage() {
        System.out.println("java com.ghgande.j2mod.modbus.cmd.ReadDiscretesTest <connection [String]> <unit [int8]> <register [int16]> <bitcount [int16]> {<repeat [int]>}");
    }

    public static void main(String[] args) {
        ReadCoilsRequest req = null;
        ReadCoilsResponse res = null;
        ModbusTransport transport = null;
        ModbusTransaction trans = null;
        int ref = 0;
        int count = 0;
        int repeat = 1;
        int unit = 0;
        try {
            if (args.length < 4 || args.length > 5) {
                ReadCoilsTest.printUsage();
                System.exit(1);
            } else {
                try {
                    transport = ModbusMasterFactory.createModbusMaster(args[0]);
                    if (transport instanceof ModbusSerialTransport) {
                        ((ModbusSerialTransport)transport).setReceiveTimeout(500);
                        if (System.getProperty("com.ghgande.j2mod.modbus.baud") != null) {
                            ((ModbusSerialTransport)transport).setBaudRate(Integer.parseInt(System.getProperty("com.ghgande.j2mod.modbus.baud")));
                        } else {
                            ((ModbusSerialTransport)transport).setBaudRate(19200);
                        }
                    }
                    Thread.sleep(2000L);
                    unit = Integer.parseInt(args[1]);
                    ref = Integer.parseInt(args[2]);
                    count = Integer.parseInt(args[3]);
                    if (args.length == 5) {
                        repeat = Integer.parseInt(args[4]);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    ReadCoilsTest.printUsage();
                    System.exit(1);
                }
            }
            req = new ReadCoilsRequest(ref, count);
            req.setUnitID(unit);
            System.out.println("Request: " + req.getHexMessage());
            trans = transport.createTransaction();
            trans.setRequest(req);
            if (trans instanceof ModbusTCPTransaction) {
                ((ModbusTCPTransaction)trans).setReconnecting(true);
            }
            int k = 0;
            do {
                trans.execute();
                res = (ReadCoilsResponse)trans.getResponse();
                System.out.println("Response: " + res.getHexMessage());
                System.out.println("Digital Inputs Status=" + res.getCoils().toString());
            } while (++k < repeat);
            transport.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.exit(0);
    }
}

