/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.cmd;

import com.ghgande.j2mod.modbus.ModbusException;
import com.ghgande.j2mod.modbus.io.ModbusSerialTransaction;
import com.ghgande.j2mod.modbus.io.ModbusSerialTransport;
import com.ghgande.j2mod.modbus.io.ModbusTransaction;
import com.ghgande.j2mod.modbus.io.ModbusTransport;
import com.ghgande.j2mod.modbus.msg.ExceptionResponse;
import com.ghgande.j2mod.modbus.msg.ModbusResponse;
import com.ghgande.j2mod.modbus.msg.ReadCommEventCounterRequest;
import com.ghgande.j2mod.modbus.msg.ReadCommEventCounterResponse;
import com.ghgande.j2mod.modbus.net.ModbusMasterFactory;
import java.io.IOException;

public class ReadCommEventCounterTest {
    private static void printUsage() {
        System.out.println("java com.ghgande.j2mod.modbus.cmd.ReadCommEventCounterTest <address{:port} [String]> <unit [int]> {<repeat [int]>}");
    }

    public static void main(String[] args) {
        ModbusTransport transport = null;
        ReadCommEventCounterRequest req = null;
        ModbusTransaction trans = null;
        int repeat = 1;
        int unit = 0;
        if (args.length < 2) {
            ReadCommEventCounterTest.printUsage();
            System.exit(1);
        }
        try {
            try {
                transport = ModbusMasterFactory.createModbusMaster(args[0]);
                if (transport == null) {
                    System.err.println("Cannot open " + args[0]);
                    System.exit(1);
                }
                if (transport instanceof ModbusSerialTransport) {
                    ((ModbusSerialTransport)transport).setReceiveTimeout(500);
                    if (System.getProperty("com.ghgande.j2mod.modbus.baud") != null) {
                        ((ModbusSerialTransport)transport).setBaudRate(Integer.parseInt(System.getProperty("com.ghgande.j2mod.modbus.baud")));
                    } else {
                        ((ModbusSerialTransport)transport).setBaudRate(19200);
                    }
                }
                Thread.sleep(2000L);
                if (args.length > 1) {
                    unit = Integer.parseInt(args[1]);
                }
                if (args.length > 2) {
                    repeat = Integer.parseInt(args[2]);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                ReadCommEventCounterTest.printUsage();
                System.exit(1);
            }
            int k = 0;
            while (k < repeat) {
                block23: {
                    req = new ReadCommEventCounterRequest();
                    req.setUnitID(unit);
                    req.setHeadless(trans instanceof ModbusSerialTransaction);
                    System.out.println("Request: " + req.getHexMessage());
                    trans = transport.createTransaction();
                    trans.setRequest(req);
                    trans.setRetries(1);
                    if (trans instanceof ModbusSerialTransaction) {
                        ((ModbusSerialTransaction)trans).setTransDelayMS(10);
                    }
                    try {
                        trans.execute();
                    }
                    catch (ModbusException x) {
                        System.err.println(x.getMessage());
                        break block23;
                    }
                    ModbusResponse res = trans.getResponse();
                    if (res != null) {
                        System.out.println("Response: " + res.getHexMessage());
                    } else {
                        System.err.println("No response to READ INPUT request.");
                    }
                    if (res instanceof ExceptionResponse) {
                        ExceptionResponse exception = (ExceptionResponse)res;
                        System.out.println(exception);
                    } else if (res instanceof ReadCommEventCounterResponse) {
                        ReadCommEventCounterResponse data = (ReadCommEventCounterResponse)res;
                        System.out.println("Status: " + data.getStatus() + ", Events " + data.getEventCount());
                    }
                }
                ++k;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            if (transport != null) {
                transport.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.exit(0);
    }
}

