/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.cmd;

import com.ghgande.j2mod.modbus.ModbusException;
import com.ghgande.j2mod.modbus.io.ModbusSerialTransaction;
import com.ghgande.j2mod.modbus.io.ModbusSerialTransport;
import com.ghgande.j2mod.modbus.io.ModbusTransaction;
import com.ghgande.j2mod.modbus.io.ModbusTransport;
import com.ghgande.j2mod.modbus.msg.ExceptionResponse;
import com.ghgande.j2mod.modbus.msg.ModbusResponse;
import com.ghgande.j2mod.modbus.msg.ReadCommEventLogRequest;
import com.ghgande.j2mod.modbus.msg.ReadCommEventLogResponse;
import com.ghgande.j2mod.modbus.net.ModbusMasterFactory;
import java.io.IOException;
import java.util.Arrays;

public class ReadCommEventLogTest {
    private static void printUsage() {
        System.out.println("java com.ghgande.j2mod.modbus.cmd.ReadCommEventLogTest <address{:port} [String]> <unit [int]> {<repeat [int]>}");
    }

    public static void main(String[] args) {
        ModbusTransport transport = null;
        ReadCommEventLogRequest req = null;
        ModbusTransaction trans = null;
        int repeat = 1;
        int unit = 0;
        if (args.length < 2) {
            ReadCommEventLogTest.printUsage();
            System.exit(1);
        }
        try {
            try {
                transport = ModbusMasterFactory.createModbusMaster(args[0]);
                if (transport == null) {
                    System.err.println("Cannot open " + args[0]);
                    System.exit(1);
                }
                if (transport instanceof ModbusSerialTransport) {
                    ((ModbusSerialTransport)transport).setReceiveTimeout(500);
                    if (System.getProperty("com.ghgande.j2mod.modbus.baud") != null) {
                        ((ModbusSerialTransport)transport).setBaudRate(Integer.parseInt(System.getProperty("com.ghgande.j2mod.modbus.baud")));
                    } else {
                        ((ModbusSerialTransport)transport).setBaudRate(19200);
                    }
                }
                Thread.sleep(2000L);
                if (args.length > 1) {
                    unit = Integer.parseInt(args[1]);
                }
                if (args.length > 2) {
                    repeat = Integer.parseInt(args[2]);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                ReadCommEventLogTest.printUsage();
                System.exit(1);
            }
            int k = 0;
            while (k < repeat) {
                block23: {
                    System.err.println("try " + k);
                    req = new ReadCommEventLogRequest();
                    req.setUnitID(unit);
                    req.setHeadless(trans instanceof ModbusSerialTransaction);
                    System.out.println("Request: " + req.getHexMessage());
                    trans = transport.createTransaction();
                    trans.setRequest(req);
                    trans.setRetries(1);
                    if (trans instanceof ModbusSerialTransaction) {
                        ((ModbusSerialTransaction)trans).setTransDelayMS(10);
                    }
                    try {
                        trans.execute();
                    }
                    catch (ModbusException x) {
                        System.err.println(x.getMessage());
                        break block23;
                    }
                    ModbusResponse res = trans.getResponse();
                    if (res != null) {
                        System.out.println("Response: " + res.getHexMessage());
                    } else {
                        System.err.println("No response to GET COMM EVENT LOG request.");
                    }
                    if (res instanceof ExceptionResponse) {
                        ExceptionResponse exception = (ExceptionResponse)res;
                        System.out.println(exception);
                    } else if (res instanceof ReadCommEventLogResponse) {
                        ReadCommEventLogResponse data = (ReadCommEventLogResponse)res;
                        System.out.println("Status: " + data.getStatus() + ", Events " + data.getEventCount() + ", Messages " + data.getMessageCount() + ", Entries " + data.getEvents().length);
                        System.out.println("Entries:");
                        System.out.println(Arrays.toString(data.getEvents()));
                    }
                }
                ++k;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            if (transport != null) {
                transport.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.exit(0);
    }
}

