/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.cmd;

import com.ghgande.j2mod.modbus.ModbusException;
import com.ghgande.j2mod.modbus.ModbusIOException;
import com.ghgande.j2mod.modbus.ModbusSlaveException;
import com.ghgande.j2mod.modbus.io.ModbusSerialTransport;
import com.ghgande.j2mod.modbus.io.ModbusTransaction;
import com.ghgande.j2mod.modbus.io.ModbusTransport;
import com.ghgande.j2mod.modbus.msg.ExceptionResponse;
import com.ghgande.j2mod.modbus.msg.ModbusResponse;
import com.ghgande.j2mod.modbus.msg.ReadFIFOQueueRequest;
import com.ghgande.j2mod.modbus.msg.ReadFIFOQueueResponse;
import com.ghgande.j2mod.modbus.net.ModbusMasterFactory;

public class ReadFIFOTest {
    private static void usage() {
        System.out.println("Usage: ReadFIFOTest connection unit fifo [repeat]");
        System.exit(1);
    }

    public static void main(String[] args) {
        ModbusTransport transport = null;
        ReadFIFOQueueRequest request = null;
        ReadFIFOQueueResponse response = null;
        ModbusTransaction trans = null;
        int unit = 0;
        int fifo = 0;
        int requestCount = 1;
        if (args.length < 3 || args.length > 4) {
            ReadFIFOTest.usage();
        }
        try {
            transport = ModbusMasterFactory.createModbusMaster(args[0]);
            if (transport instanceof ModbusSerialTransport) {
                ((ModbusSerialTransport)transport).setReceiveTimeout(500);
                if (System.getProperty("com.ghgande.j2mod.modbus.baud") != null) {
                    ((ModbusSerialTransport)transport).setBaudRate(Integer.parseInt(System.getProperty("com.ghgande.j2mod.modbus.baud")));
                } else {
                    ((ModbusSerialTransport)transport).setBaudRate(19200);
                }
                Thread.sleep(2000L);
            }
            unit = Integer.parseInt(args[1]);
            fifo = Integer.parseInt(args[2]);
            if (args.length > 3) {
                requestCount = Integer.parseInt(args[3]);
            }
        }
        catch (NumberFormatException x) {
            System.err.println("Invalid parameter");
            ReadFIFOTest.usage();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ReadFIFOTest.usage();
            System.exit(1);
        }
        try {
            int i = 0;
            while (i < requestCount) {
                block22: {
                    request = new ReadFIFOQueueRequest();
                    request.setUnitID(unit);
                    request.setReference(fifo);
                    System.out.println("Request: " + request.getHexMessage());
                    trans = transport.createTransaction();
                    trans.setRequest(request);
                    try {
                        trans.execute();
                    }
                    catch (ModbusSlaveException x) {
                        System.err.println("Slave Exception: " + x.getLocalizedMessage());
                        break block22;
                    }
                    catch (ModbusIOException x) {
                        System.err.println("I/O Exception: " + x.getLocalizedMessage());
                        break block22;
                    }
                    catch (ModbusException x) {
                        System.err.println("Modbus Exception: " + x.getLocalizedMessage());
                        break block22;
                    }
                    ModbusResponse dummy = trans.getResponse();
                    if (dummy == null) {
                        System.err.println("No response for transaction " + i);
                    } else if (dummy instanceof ExceptionResponse) {
                        ExceptionResponse exception = (ExceptionResponse)dummy;
                        System.err.println(exception);
                    } else if (dummy instanceof ReadFIFOQueueResponse) {
                        response = (ReadFIFOQueueResponse)dummy;
                        System.out.println("Response: " + response.getHexMessage());
                        int count = response.getWordCount();
                        System.out.println(String.valueOf(count) + " values");
                        int j = 0;
                        while (j < count) {
                            short value = (short)response.getRegister(j);
                            System.out.println("data[" + j + "] = " + value);
                            ++j;
                        }
                    } else {
                        System.out.println("Unknown Response: " + dummy.getHexMessage());
                    }
                }
                ++i;
            }
            transport.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.exit(0);
    }
}

