/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.cmd;

import com.ghgande.j2mod.modbus.ModbusException;
import com.ghgande.j2mod.modbus.ModbusIOException;
import com.ghgande.j2mod.modbus.ModbusSlaveException;
import com.ghgande.j2mod.modbus.io.ModbusSerialTransport;
import com.ghgande.j2mod.modbus.io.ModbusTransaction;
import com.ghgande.j2mod.modbus.io.ModbusTransport;
import com.ghgande.j2mod.modbus.msg.ExceptionResponse;
import com.ghgande.j2mod.modbus.msg.ModbusResponse;
import com.ghgande.j2mod.modbus.msg.ReadCommEventCounterRequest;
import com.ghgande.j2mod.modbus.msg.ReadCommEventCounterResponse;
import com.ghgande.j2mod.modbus.msg.ReadFileRecordRequest;
import com.ghgande.j2mod.modbus.msg.ReadFileRecordResponse;
import com.ghgande.j2mod.modbus.net.ModbusMasterFactory;
import java.util.Arrays;

public class ReadFileRecordTest {
    private static void usage() {
        System.out.println("Usage: ReadFileRecord connection unit file record registers [repeat]");
        System.exit(1);
    }

    public static void main(String[] args) {
        ModbusTransport transport = null;
        ReadFileRecordRequest request = null;
        ReadFileRecordResponse response = null;
        ModbusTransaction trans = null;
        int unit = 0;
        int file = 0;
        int record = 0;
        int registers = 0;
        int requestCount = 1;
        if (args.length < 5 || args.length > 6) {
            ReadFileRecordTest.usage();
        }
        try {
            transport = ModbusMasterFactory.createModbusMaster(args[0]);
            if (transport instanceof ModbusSerialTransport) {
                ((ModbusSerialTransport)transport).setReceiveTimeout(500);
                if (System.getProperty("com.ghgande.j2mod.modbus.baud") != null) {
                    ((ModbusSerialTransport)transport).setBaudRate(Integer.parseInt(System.getProperty("com.ghgande.j2mod.modbus.baud")));
                } else {
                    ((ModbusSerialTransport)transport).setBaudRate(19200);
                }
                Thread.sleep(2000L);
            }
            unit = Integer.parseInt(args[1]);
            file = Integer.parseInt(args[2]);
            record = Integer.parseInt(args[3]);
            registers = Integer.parseInt(args[4]);
            if (args.length > 5) {
                requestCount = Integer.parseInt(args[5]);
            }
        }
        catch (NumberFormatException x) {
            System.err.println("Invalid parameter");
            ReadFileRecordTest.usage();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ReadFileRecordTest.usage();
            System.exit(1);
        }
        try {
            int i = 0;
            while (i < requestCount) {
                block26: {
                    request = new ReadFileRecordRequest();
                    request.setUnitID(unit);
                    ReadFileRecordRequest readFileRecordRequest = request;
                    readFileRecordRequest.getClass();
                    ReadFileRecordRequest.RecordRequest recordRequest = new ReadFileRecordRequest.RecordRequest(readFileRecordRequest, file, record + i, registers);
                    request.addRequest(recordRequest);
                    System.out.println("Request: " + request.getHexMessage());
                    trans = transport.createTransaction();
                    trans.setRequest(request);
                    try {
                        trans.execute();
                    }
                    catch (ModbusSlaveException x) {
                        System.err.println("Slave Exception: " + x.getLocalizedMessage());
                        break block26;
                    }
                    catch (ModbusIOException x) {
                        System.err.println("I/O Exception: " + x.getLocalizedMessage());
                        break block26;
                    }
                    catch (ModbusException x) {
                        System.err.println("Modbus Exception: " + x.getLocalizedMessage());
                        break block26;
                    }
                    ModbusResponse dummy = trans.getResponse();
                    if (dummy == null) {
                        System.err.println("No response for transaction " + i);
                    } else if (dummy instanceof ExceptionResponse) {
                        ExceptionResponse exception = (ExceptionResponse)dummy;
                        System.err.println(exception);
                    } else if (dummy instanceof ReadFileRecordResponse) {
                        response = (ReadFileRecordResponse)dummy;
                        System.out.println("Response: " + response.getHexMessage());
                        int count = response.getRecordCount();
                        int j = 0;
                        while (j < count) {
                            ReadFileRecordResponse.RecordResponse data = response.getRecord(j);
                            short[] values = new short[data.getWordCount()];
                            int k = 0;
                            while (k < data.getWordCount()) {
                                values[k] = data.getRegister(k).toShort();
                                ++k;
                            }
                            System.out.println("data[" + i + "][" + j + "] = " + Arrays.toString(values));
                            ++j;
                        }
                    } else {
                        System.out.println("Unknown Response: " + dummy.getHexMessage());
                    }
                }
                ++i;
            }
            ReadCommEventCounterRequest eventRequest = new ReadCommEventCounterRequest();
            eventRequest.setUnitID(unit);
            trans = transport.createTransaction();
            trans.setRequest(eventRequest);
            try {
                trans.execute();
                ModbusResponse dummy = trans.getResponse();
                if (dummy instanceof ReadCommEventCounterResponse) {
                    ReadCommEventCounterResponse eventResponse = (ReadCommEventCounterResponse)dummy;
                    System.out.println("  Events: " + eventResponse.getEventCount());
                }
            }
            catch (ModbusException modbusException) {
                // empty catch block
            }
            transport.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.exit(0);
    }
}

