/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.cmd;

import com.ghgande.j2mod.modbus.ModbusException;
import com.ghgande.j2mod.modbus.io.ModbusRTUTransport;
import com.ghgande.j2mod.modbus.io.ModbusSerialTransaction;
import com.ghgande.j2mod.modbus.io.ModbusSerialTransport;
import com.ghgande.j2mod.modbus.io.ModbusTCPTransport;
import com.ghgande.j2mod.modbus.io.ModbusTransaction;
import com.ghgande.j2mod.modbus.io.ModbusTransport;
import com.ghgande.j2mod.modbus.msg.ExceptionResponse;
import com.ghgande.j2mod.modbus.msg.ModbusResponse;
import com.ghgande.j2mod.modbus.msg.ReadMultipleRegistersRequest;
import com.ghgande.j2mod.modbus.msg.ReadMultipleRegistersResponse;
import com.ghgande.j2mod.modbus.net.ModbusMasterFactory;
import java.io.IOException;
import java.util.Arrays;

public class ReadHoldingRegistersTest {
    private static void printUsage() {
        System.out.println("java com.ghgande.j2mod.modbus.cmd.ReadHoldingRegistersTest <address{:port{:unit}} [String]> <base [int]> <count [int]> {<repeat [int]>}");
    }

    public static void main(String[] args) {
        ModbusTransport transport = null;
        ReadMultipleRegistersRequest req = null;
        ModbusTransaction trans = null;
        int ref = 0;
        int count = 0;
        int repeat = 1;
        int unit = 0;
        if (args.length < 3) {
            ReadHoldingRegistersTest.printUsage();
            System.exit(1);
        }
        try {
            try {
                String[] parts;
                transport = ModbusMasterFactory.createModbusMaster(args[0]);
                if (transport == null) {
                    System.err.println("Cannot open " + args[0]);
                    System.exit(1);
                }
                if (transport instanceof ModbusSerialTransport) {
                    ((ModbusSerialTransport)transport).setReceiveTimeout(500);
                    if (System.getProperty("com.ghgande.j2mod.modbus.baud") != null) {
                        ((ModbusSerialTransport)transport).setBaudRate(Integer.parseInt(System.getProperty("com.ghgande.j2mod.modbus.baud")));
                    } else {
                        ((ModbusSerialTransport)transport).setBaudRate(19200);
                    }
                }
                Thread.sleep(2000L);
                ref = Integer.parseInt(args[1]);
                count = Integer.parseInt(args[2]);
                if (args.length == 4) {
                    repeat = Integer.parseInt(args[3]);
                }
                if (transport instanceof ModbusTCPTransport) {
                    parts = args[0].split(":");
                    if (parts.length >= 4) {
                        unit = Integer.parseInt(parts[3]);
                    }
                } else if (transport instanceof ModbusRTUTransport) {
                    String baud;
                    parts = args[0].split(":");
                    if (parts.length >= 3) {
                        unit = Integer.parseInt(parts[2]);
                    }
                    if ((baud = System.getProperty("com.ghgande.j2mod.modbus.baud")) != null) {
                        ((ModbusRTUTransport)transport).setBaudRate(Integer.parseInt(baud));
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                ReadHoldingRegistersTest.printUsage();
                System.exit(1);
            }
            req = new ReadMultipleRegistersRequest(ref, count);
            req.setUnitID(unit);
            trans = transport.createTransaction();
            trans.setRequest(req);
            req.setHeadless(trans instanceof ModbusSerialTransaction);
            System.out.println("Request: " + req.getHexMessage());
            int i = 0;
            while (i < repeat) {
                block27: {
                    try {
                        trans.execute();
                    }
                    catch (ModbusException x) {
                        System.err.println(x.getMessage());
                        break block27;
                    }
                    ModbusResponse res = trans.getResponse();
                    if (res != null) {
                        System.out.println("Response: " + res.getHexMessage());
                    } else {
                        System.err.println("No response to READ HOLDING request.");
                    }
                    if (res instanceof ExceptionResponse) {
                        ExceptionResponse exception = (ExceptionResponse)res;
                        System.out.println(exception);
                    } else if (res instanceof ReadMultipleRegistersResponse) {
                        ReadMultipleRegistersResponse data = (ReadMultipleRegistersResponse)res;
                        Object[] values = data.getRegisters();
                        System.out.println("Data: " + Arrays.toString(values));
                    }
                }
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            if (transport != null) {
                transport.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.exit(0);
    }
}

