/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.cmd;

import com.ghgande.j2mod.modbus.ModbusCoupler;
import com.ghgande.j2mod.modbus.io.ModbusSerialTransaction;
import com.ghgande.j2mod.modbus.msg.ReadInputRegistersRequest;
import com.ghgande.j2mod.modbus.msg.ReadInputRegistersResponse;
import com.ghgande.j2mod.modbus.net.SerialConnection;
import com.ghgande.j2mod.modbus.util.SerialParameters;

public class SerialAITest {
    public static void main(String[] args) {
        SerialConnection con = null;
        ModbusSerialTransaction trans = null;
        ReadInputRegistersRequest req = null;
        ReadInputRegistersResponse res = null;
        String portname = null;
        int unitid = 0;
        int ref = 0;
        int count = 0;
        int repeat = 1;
        try {
            if (args.length < 4) {
                SerialAITest.printUsage();
                System.exit(1);
            } else {
                try {
                    portname = args[0];
                    unitid = Integer.parseInt(args[1]);
                    ref = Integer.parseInt(args[2]);
                    count = Integer.parseInt(args[3]);
                    if (args.length == 5) {
                        repeat = Integer.parseInt(args[4]);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    SerialAITest.printUsage();
                    System.exit(1);
                }
            }
            ModbusCoupler.getReference().setUnitID(unitid);
            System.out.println("com.ghgande.j2mod.modbus.debug set to: " + System.getProperty("com.ghgande.j2mod.modbus.debug"));
            SerialParameters params = new SerialParameters();
            params.setPortName(portname);
            params.setBaudRate(9600);
            params.setDatabits(8);
            params.setParity("None");
            params.setStopbits(1);
            params.setEncoding("ascii");
            params.setEcho(false);
            System.out.println("Encoding [" + params.getEncoding() + "]");
            con = new SerialConnection(params);
            con.open();
            req = new ReadInputRegistersRequest(ref, count);
            req.setUnitID(unitid);
            req.setHeadless();
            System.out.println("Request: " + req.getHexMessage());
            trans = new ModbusSerialTransaction(con);
            trans.setRequest(req);
            int k = 0;
            do {
                trans.execute();
                res = (ReadInputRegistersResponse)trans.getResponse();
                System.out.println("Response: " + res.getHexMessage());
                int n = 0;
                while (n < res.getWordCount()) {
                    System.out.println("Word " + n + "=" + res.getRegisterValue(n));
                    ++n;
                }
            } while (++k < repeat);
            con.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            con.close();
        }
    }

    private static void printUsage() {
        System.out.println("java com.ghgande.j2mod.modbus.cmd.SerialAITest <portname [String]>  <Unit Address [int8]> <register [int16]> <wordcount [int16]> {<repeat [int]>}");
    }
}

