/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.cmd;

import com.ghgande.j2mod.modbus.ModbusCoupler;
import com.ghgande.j2mod.modbus.net.ModbusSerialListener;
import com.ghgande.j2mod.modbus.procimg.SimpleDigitalIn;
import com.ghgande.j2mod.modbus.procimg.SimpleDigitalOut;
import com.ghgande.j2mod.modbus.procimg.SimpleInputRegister;
import com.ghgande.j2mod.modbus.procimg.SimpleProcessImage;
import com.ghgande.j2mod.modbus.procimg.SimpleRegister;
import com.ghgande.j2mod.modbus.util.SerialParameters;

public class SerialSlaveTest {
    public static void main(String[] args) {
        ModbusSerialListener listener = null;
        SimpleProcessImage spi = new SimpleProcessImage();
        String portname = null;
        boolean hasUnit = false;
        int unit = 2;
        int coils = 2;
        int discretes = 4;
        boolean hasInputs = false;
        int inputs = 1;
        boolean hasHoldings = false;
        int holdings = 1;
        int arg = 0;
        arg = 0;
        while (arg < args.length) {
            if (args[arg].equals("--port") || args[arg].equals("-p")) {
                portname = args[++arg];
            } else if (args[arg].equals("--unit") || args[arg].equals("-u")) {
                unit = Integer.parseInt(args[++arg]);
                hasUnit = true;
            } else if (args[arg].equals("--coils") || args[arg].equals("-c")) {
                coils = Integer.parseInt(args[++arg]);
            } else if (args[arg].equals("--discretes") || args[arg].equals("-d")) {
                discretes = Integer.parseInt(args[++arg]);
            } else if (args[arg].equals("--inputs") || args[arg].equals("-i")) {
                inputs = Integer.parseInt(args[++arg]);
                hasInputs = true;
            } else {
                if (!args[arg].equals("--holdings") && !args[arg].equals("-h")) break;
                holdings = Integer.parseInt(args[++arg]);
                hasHoldings = true;
            }
            ++arg;
        }
        if (arg < args.length && portname == null) {
            portname = args[arg++];
        }
        if (arg < args.length && !hasUnit) {
            unit = Integer.parseInt(args[arg++]);
        }
        System.out.println("j2mod ModbusSerial Slave");
        try {
            spi = new SimpleProcessImage();
            int i = 0;
            while (i < coils) {
                spi.addDigitalOut(new SimpleDigitalOut(i % 2 == 0));
                ++i;
            }
            i = 0;
            while (i < discretes) {
                spi.addDigitalIn(new SimpleDigitalIn(i % 2 == 0));
                ++i;
            }
            if (hasHoldings) {
                System.out.println("Adding " + holdings + " holding registers");
                i = 0;
                while (i < holdings) {
                    spi.addRegister(new SimpleRegister(i));
                    ++i;
                }
            } else {
                spi.addRegister(new SimpleRegister(251));
            }
            if (hasInputs) {
                System.out.println("Adding " + inputs + " input registers");
                i = 0;
                while (i < inputs) {
                    spi.addInputRegister(new SimpleInputRegister(i));
                    ++i;
                }
            } else {
                spi.addInputRegister(new SimpleInputRegister(45));
            }
            ModbusCoupler.getReference().setProcessImage(spi);
            ModbusCoupler.getReference().setMaster(false);
            ModbusCoupler.getReference().setUnitID(unit);
            SerialParameters params = new SerialParameters();
            params.setPortName(portname);
            params.setBaudRate(19200);
            params.setDatabits(8);
            params.setParity("None");
            params.setStopbits(1);
            params.setEncoding("rtu");
            params.setEcho(false);
            System.out.println("Encoding [" + params.getEncoding() + "]");
            listener = new ModbusSerialListener(params);
            listener.setListening(true);
            new Thread(listener).start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

