/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.cmd;

import com.ghgande.j2mod.modbus.ModbusException;
import com.ghgande.j2mod.modbus.ModbusIOException;
import com.ghgande.j2mod.modbus.ModbusSlaveException;
import com.ghgande.j2mod.modbus.io.ModbusUDPTransaction;
import com.ghgande.j2mod.modbus.msg.ExceptionResponse;
import com.ghgande.j2mod.modbus.msg.ModbusResponse;
import com.ghgande.j2mod.modbus.msg.ReadFileRecordRequest;
import com.ghgande.j2mod.modbus.msg.ReadFileRecordResponse;
import com.ghgande.j2mod.modbus.msg.WriteFileRecordRequest;
import com.ghgande.j2mod.modbus.msg.WriteFileRecordResponse;
import com.ghgande.j2mod.modbus.net.UDPMasterConnection;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;

public class UDPWriteRecordTest {
    private static void usage() {
        System.out.println("Usage: UDPWriteRecordTest address[:port[:unit]] file record registers [count]");
        System.exit(1);
    }

    public static void main(String[] args) {
        InetAddress ipAddress = null;
        int port = 502;
        int unit = 0;
        UDPMasterConnection connection = null;
        ReadFileRecordRequest rdRequest = null;
        ReadFileRecordResponse rdResponse = null;
        WriteFileRecordRequest wrRequest = null;
        WriteFileRecordResponse wrResponse = null;
        ModbusUDPTransaction trans = null;
        int file = 0;
        int record = 0;
        int registers = 0;
        int requestCount = 1;
        if (args.length < 4 || args.length > 5) {
            UDPWriteRecordTest.usage();
        }
        String serverAddress = args[0];
        String[] parts = serverAddress.split(":");
        String hostName = parts[0];
        try {
            if (parts.length > 1) {
                port = Integer.parseInt(parts[1]);
                if (parts.length > 2) {
                    unit = Integer.parseInt(parts[2]);
                }
            }
            ipAddress = InetAddress.getByName(hostName);
            file = Integer.parseInt(args[1]);
            record = Integer.parseInt(args[2]);
            registers = Integer.parseInt(args[3]);
            if (args.length > 4) {
                requestCount = Integer.parseInt(args[4]);
            }
        }
        catch (NumberFormatException x) {
            System.err.println("Invalid parameter");
            UDPWriteRecordTest.usage();
        }
        catch (UnknownHostException x) {
            System.err.println("Unknown host: " + hostName);
            System.exit(1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            UDPWriteRecordTest.usage();
            System.exit(1);
        }
        try {
            connection = new UDPMasterConnection(ipAddress);
            connection.setPort(port);
            connection.connect();
            connection.setTimeout(500);
            System.out.println("Connected to " + ipAddress.toString() + ":" + connection.getPort());
            int i = 0;
            while (i < requestCount) {
                block35: {
                    rdRequest = new ReadFileRecordRequest();
                    rdRequest.setUnitID(unit);
                    ReadFileRecordRequest readFileRecordRequest = rdRequest;
                    readFileRecordRequest.getClass();
                    ReadFileRecordRequest.RecordRequest recordRequest = new ReadFileRecordRequest.RecordRequest(readFileRecordRequest, file, record + i, registers);
                    rdRequest.addRequest(recordRequest);
                    System.out.println("Request: " + rdRequest.getHexMessage());
                    trans = new ModbusUDPTransaction(connection);
                    trans.setRequest(rdRequest);
                    try {
                        trans.execute();
                    }
                    catch (ModbusSlaveException x) {
                        System.err.println("Slave Exception: " + x.getLocalizedMessage());
                        break block35;
                    }
                    catch (ModbusIOException x) {
                        System.err.println("I/O Exception: " + x.getLocalizedMessage());
                        break block35;
                    }
                    catch (ModbusException x) {
                        System.err.println("Modbus Exception: " + x.getLocalizedMessage());
                        break block35;
                    }
                    wrRequest = new WriteFileRecordRequest();
                    wrRequest.setUnitID(unit);
                    ModbusResponse dummy = trans.getResponse();
                    if (dummy == null) {
                        System.err.println("No response for transaction " + i);
                    } else if (dummy instanceof ExceptionResponse) {
                        ExceptionResponse exception = (ExceptionResponse)dummy;
                        System.err.println(exception);
                    } else {
                        short[] values;
                        Object data;
                        int j;
                        if (dummy instanceof ReadFileRecordResponse) {
                            rdResponse = (ReadFileRecordResponse)dummy;
                            System.out.println("Response: " + rdResponse.getHexMessage());
                            int count = rdResponse.getRecordCount();
                            j = 0;
                            while (j < count) {
                                data = rdResponse.getRecord(j);
                                values = new short[((ReadFileRecordResponse.RecordResponse)data).getWordCount()];
                                int k = 0;
                                while (k < ((ReadFileRecordResponse.RecordResponse)data).getWordCount()) {
                                    values[k] = ((ReadFileRecordResponse.RecordResponse)data).getRegister(k).toShort();
                                    ++k;
                                }
                                System.out.println("read data[" + j + "] = " + Arrays.toString(values));
                                WriteFileRecordRequest writeFileRecordRequest = wrRequest;
                                writeFileRecordRequest.getClass();
                                WriteFileRecordRequest.RecordRequest wrData = new WriteFileRecordRequest.RecordRequest(writeFileRecordRequest, file, record + i, values);
                                wrRequest.addRequest(wrData);
                                ++j;
                            }
                        } else {
                            System.out.println("Unknown Response: " + dummy.getHexMessage());
                        }
                        trans = new ModbusUDPTransaction(connection);
                        trans.setRequest(wrRequest);
                        try {
                            trans.execute();
                        }
                        catch (ModbusSlaveException x) {
                            System.err.println("Slave Exception: " + x.getLocalizedMessage());
                            break block35;
                        }
                        catch (ModbusIOException x) {
                            System.err.println("I/O Exception: " + x.getLocalizedMessage());
                            break block35;
                        }
                        catch (ModbusException x) {
                            System.err.println("Modbus Exception: " + x.getLocalizedMessage());
                            break block35;
                        }
                        dummy = trans.getResponse();
                        if (dummy == null) {
                            System.err.println("No response for transaction " + i);
                        } else if (dummy instanceof ExceptionResponse) {
                            ExceptionResponse exception = (ExceptionResponse)dummy;
                            System.err.println(exception);
                        } else if (dummy instanceof WriteFileRecordResponse) {
                            wrResponse = (WriteFileRecordResponse)dummy;
                            System.out.println("Response: " + wrResponse.getHexMessage());
                            int count = wrResponse.getRequestCount();
                            j = 0;
                            while (j < count) {
                                data = wrResponse.getRecord(j);
                                values = new short[((WriteFileRecordResponse.RecordResponse)data).getWordCount()];
                                int k = 0;
                                while (k < ((WriteFileRecordResponse.RecordResponse)data).getWordCount()) {
                                    values[k] = ((WriteFileRecordResponse.RecordResponse)data).getRegister(k).toShort();
                                    ++k;
                                }
                                System.out.println("write response data[" + j + "] = " + Arrays.toString(values));
                                ++j;
                            }
                        } else {
                            System.out.println("Unknown Response: " + dummy.getHexMessage());
                        }
                    }
                }
                ++i;
            }
            connection.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

