/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.cmd;

import com.ghgande.j2mod.modbus.io.ModbusSerialTransport;
import com.ghgande.j2mod.modbus.io.ModbusTransaction;
import com.ghgande.j2mod.modbus.io.ModbusTransport;
import com.ghgande.j2mod.modbus.msg.WriteCoilRequest;
import com.ghgande.j2mod.modbus.msg.WriteCoilResponse;
import com.ghgande.j2mod.modbus.net.ModbusMasterFactory;

public class WriteCoilTest {
    private static void printUsage() {
        System.out.println("java com.ghgande.j2mod.modbus.cmd.WriteCoilTest <connection [String]> <unit [int8]> <coil [int16]> <state [boolean]> {<repeat [int]>}");
    }

    public static void main(String[] args) {
        WriteCoilRequest req = null;
        ModbusTransport transport = null;
        ModbusTransaction trans = null;
        int ref = 0;
        boolean value = false;
        int repeat = 1;
        int unit = 0;
        if (args.length < 4) {
            WriteCoilTest.printUsage();
            System.exit(1);
        }
        try {
            try {
                transport = ModbusMasterFactory.createModbusMaster(args[0]);
                if (transport instanceof ModbusSerialTransport) {
                    ((ModbusSerialTransport)transport).setReceiveTimeout(500);
                    if (System.getProperty("com.ghgande.j2mod.modbus.baud") != null) {
                        ((ModbusSerialTransport)transport).setBaudRate(Integer.parseInt(System.getProperty("com.ghgande.j2mod.modbus.baud")));
                    } else {
                        ((ModbusSerialTransport)transport).setBaudRate(19200);
                    }
                }
                Thread.sleep(2000L);
                unit = Integer.parseInt(args[1]);
                ref = Integer.parseInt(args[2]);
                value = "true".equals(args[3]);
                if (args.length == 5) {
                    repeat = Integer.parseInt(args[4]);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                WriteCoilTest.printUsage();
                System.exit(1);
            }
            req = new WriteCoilRequest(ref, value);
            req.setUnitID(unit);
            System.out.println("Request: " + req.getHexMessage());
            trans = transport.createTransaction();
            trans.setRequest(req);
            int count = 0;
            while (count < repeat) {
                trans.execute();
                System.out.println("Response: " + trans.getResponse().getHexMessage());
                WriteCoilResponse data = (WriteCoilResponse)trans.getResponse();
                if (data != null) {
                    System.out.println("Coil = " + data.getCoil());
                }
                ++count;
            }
            transport.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.exit(0);
    }
}

