/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.cmd;

import com.ghgande.j2mod.modbus.ModbusException;
import com.ghgande.j2mod.modbus.ModbusIOException;
import com.ghgande.j2mod.modbus.ModbusSlaveException;
import com.ghgande.j2mod.modbus.io.ModbusSerialTransport;
import com.ghgande.j2mod.modbus.io.ModbusTransaction;
import com.ghgande.j2mod.modbus.io.ModbusTransport;
import com.ghgande.j2mod.modbus.msg.ExceptionResponse;
import com.ghgande.j2mod.modbus.msg.ModbusResponse;
import com.ghgande.j2mod.modbus.msg.WriteFileRecordRequest;
import com.ghgande.j2mod.modbus.msg.WriteFileRecordResponse;
import com.ghgande.j2mod.modbus.net.ModbusMasterFactory;
import java.io.IOException;
import java.util.Arrays;

public class WriteFileRecordTest {
    private static void usage() {
        System.out.println("Usage: WriteFileRecordTest connection unit file record value [value ...]");
        System.exit(1);
    }

    public static void main(String[] args) {
        block32: {
            ModbusTransport transport = null;
            WriteFileRecordRequest request = null;
            WriteFileRecordResponse response = null;
            ModbusTransaction trans = null;
            int unit = 0;
            int file = 0;
            int record = 0;
            int registers = 0;
            short[] values = null;
            boolean isSerial = false;
            if (args.length < 6) {
                WriteFileRecordTest.usage();
            }
            try {
                transport = ModbusMasterFactory.createModbusMaster(args[0]);
                if (transport instanceof ModbusSerialTransport) {
                    ((ModbusSerialTransport)transport).setReceiveTimeout(500);
                    ((ModbusSerialTransport)transport).setBaudRate(19200);
                    isSerial = true;
                    Thread.sleep(2000L);
                }
                unit = Integer.parseInt(args[1]);
                file = Integer.parseInt(args[2]);
                record = Integer.parseInt(args[3]);
                if (args.length > 4) {
                    registers = args.length - 4;
                    values = new short[registers];
                    int i = 0;
                    while (i < registers) {
                        values[i] = Short.parseShort(args[i + 4]);
                        ++i;
                    }
                }
            }
            catch (NumberFormatException x) {
                System.err.println("Invalid parameter");
                WriteFileRecordTest.usage();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                WriteFileRecordTest.usage();
                System.exit(1);
            }
            try {
                try {
                    request = new WriteFileRecordRequest();
                    request.setUnitID(unit);
                    if (isSerial) {
                        request.setHeadless(true);
                    }
                    WriteFileRecordRequest writeFileRecordRequest = request;
                    writeFileRecordRequest.getClass();
                    WriteFileRecordRequest.RecordRequest recordRequest = new WriteFileRecordRequest.RecordRequest(writeFileRecordRequest, file, record, values);
                    request.addRequest(recordRequest);
                    System.out.println("Request: " + request.getHexMessage());
                    trans = transport.createTransaction();
                    trans.setRequest(request);
                    try {
                        trans.execute();
                    }
                    catch (ModbusSlaveException x) {
                        System.err.println("Slave Exception: " + x.getLocalizedMessage());
                        System.exit(1);
                    }
                    catch (ModbusIOException x) {
                        System.err.println("I/O Exception: " + x.getLocalizedMessage());
                        System.exit(1);
                    }
                    catch (ModbusException x) {
                        System.err.println("Modbus Exception: " + x.getLocalizedMessage());
                        System.exit(1);
                    }
                    ModbusResponse dummy = trans.getResponse();
                    if (dummy == null) {
                        System.err.println("No response for transaction ");
                        System.exit(1);
                    }
                    if (dummy instanceof ExceptionResponse) {
                        ExceptionResponse exception = (ExceptionResponse)dummy;
                        System.err.println(exception);
                    } else if (dummy instanceof WriteFileRecordResponse) {
                        response = (WriteFileRecordResponse)dummy;
                        System.out.println("Response: " + response.getHexMessage());
                        int count = response.getRequestCount();
                        int j = 0;
                        while (j < count) {
                            WriteFileRecordResponse.RecordResponse data = response.getRecord(j);
                            values = new short[data.getWordCount()];
                            int k = 0;
                            while (k < data.getWordCount()) {
                                values[k] = data.getRegister(k).toShort();
                                ++k;
                            }
                            System.out.println("data[" + j + "] = " + Arrays.toString(values));
                            ++j;
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    if (transport != null) {
                        try {
                            transport.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block32;
                }
            }
            catch (Throwable throwable) {
                if (transport != null) {
                    try {
                        transport.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (transport != null) {
                try {
                    transport.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        System.exit(0);
    }
}

