/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.facade;

import com.ghgande.j2mod.modbus.ModbusException;
import com.ghgande.j2mod.modbus.io.ModbusTCPTransaction;
import com.ghgande.j2mod.modbus.msg.ReadCoilsRequest;
import com.ghgande.j2mod.modbus.msg.ReadCoilsResponse;
import com.ghgande.j2mod.modbus.msg.ReadInputDiscretesRequest;
import com.ghgande.j2mod.modbus.msg.ReadInputDiscretesResponse;
import com.ghgande.j2mod.modbus.msg.ReadInputRegistersRequest;
import com.ghgande.j2mod.modbus.msg.ReadInputRegistersResponse;
import com.ghgande.j2mod.modbus.msg.ReadMultipleRegistersRequest;
import com.ghgande.j2mod.modbus.msg.ReadMultipleRegistersResponse;
import com.ghgande.j2mod.modbus.msg.WriteCoilRequest;
import com.ghgande.j2mod.modbus.msg.WriteCoilResponse;
import com.ghgande.j2mod.modbus.msg.WriteMultipleCoilsRequest;
import com.ghgande.j2mod.modbus.msg.WriteMultipleRegistersRequest;
import com.ghgande.j2mod.modbus.msg.WriteSingleRegisterRequest;
import com.ghgande.j2mod.modbus.net.TCPMasterConnection;
import com.ghgande.j2mod.modbus.procimg.InputRegister;
import com.ghgande.j2mod.modbus.procimg.Register;
import com.ghgande.j2mod.modbus.util.BitVector;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class ModbusTCPMaster {
    private TCPMasterConnection m_Connection;
    private InetAddress m_SlaveAddress;
    private ModbusTCPTransaction m_Transaction;
    private ReadCoilsRequest m_ReadCoilsRequest;
    private ReadInputDiscretesRequest m_ReadInputDiscretesRequest;
    private WriteCoilRequest m_WriteCoilRequest;
    private WriteMultipleCoilsRequest m_WriteMultipleCoilsRequest;
    private ReadInputRegistersRequest m_ReadInputRegistersRequest;
    private ReadMultipleRegistersRequest m_ReadMultipleRegistersRequest;
    private WriteSingleRegisterRequest m_WriteSingleRegisterRequest;
    private WriteMultipleRegistersRequest m_WriteMultipleRegistersRequest;
    private boolean m_Reconnecting = false;

    public ModbusTCPMaster(String addr) {
        try {
            this.m_SlaveAddress = InetAddress.getByName(addr);
            this.m_Connection = new TCPMasterConnection(this.m_SlaveAddress);
            this.m_ReadCoilsRequest = new ReadCoilsRequest();
            this.m_ReadInputDiscretesRequest = new ReadInputDiscretesRequest();
            this.m_WriteCoilRequest = new WriteCoilRequest();
            this.m_WriteMultipleCoilsRequest = new WriteMultipleCoilsRequest();
            this.m_ReadInputRegistersRequest = new ReadInputRegistersRequest();
            this.m_ReadMultipleRegistersRequest = new ReadMultipleRegistersRequest();
            this.m_WriteSingleRegisterRequest = new WriteSingleRegisterRequest();
            this.m_WriteMultipleRegistersRequest = new WriteMultipleRegistersRequest();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public ModbusTCPMaster(String addr, int port) {
        this(addr);
        this.m_Connection.setPort(port);
    }

    public void connect() throws Exception {
        if (this.m_Connection != null && !this.m_Connection.isConnected()) {
            this.m_Connection.connect();
            this.m_Transaction = new ModbusTCPTransaction(this.m_Connection);
            this.m_Transaction.setReconnecting(this.m_Reconnecting);
        }
    }

    public void disconnect() {
        if (this.m_Connection != null && this.m_Connection.isConnected()) {
            this.m_Connection.close();
            this.m_Transaction = null;
        }
    }

    public void setReconnecting(boolean b) {
        this.m_Reconnecting = b;
        if (this.m_Transaction != null) {
            this.m_Transaction.setReconnecting(b);
        }
    }

    public boolean isReconnecting() {
        return this.m_Reconnecting;
    }

    public synchronized BitVector readCoils(int ref, int count) throws ModbusException {
        this.m_ReadCoilsRequest.setReference(ref);
        this.m_ReadCoilsRequest.setBitCount(count);
        this.m_Transaction.setRequest(this.m_ReadCoilsRequest);
        this.m_Transaction.execute();
        BitVector bv = ((ReadCoilsResponse)this.m_Transaction.getResponse()).getCoils();
        bv.forceSize(count);
        return bv;
    }

    public synchronized boolean writeCoil(int unitid, int ref, boolean state) throws ModbusException {
        this.m_WriteCoilRequest.setUnitID(unitid);
        this.m_WriteCoilRequest.setReference(ref);
        this.m_WriteCoilRequest.setCoil(state);
        this.m_Transaction.setRequest(this.m_WriteCoilRequest);
        this.m_Transaction.execute();
        return ((WriteCoilResponse)this.m_Transaction.getResponse()).getCoil();
    }

    public synchronized void writeMultipleCoils(int ref, BitVector coils) throws ModbusException {
        this.m_WriteMultipleCoilsRequest.setReference(ref);
        this.m_WriteMultipleCoilsRequest.setCoils(coils);
        this.m_Transaction.setRequest(this.m_WriteMultipleCoilsRequest);
        this.m_Transaction.execute();
    }

    public synchronized BitVector readInputDiscretes(int ref, int count) throws ModbusException {
        this.m_ReadInputDiscretesRequest.setReference(ref);
        this.m_ReadInputDiscretesRequest.setBitCount(count);
        this.m_Transaction.setRequest(this.m_ReadInputDiscretesRequest);
        this.m_Transaction.execute();
        BitVector bv = ((ReadInputDiscretesResponse)this.m_Transaction.getResponse()).getDiscretes();
        bv.forceSize(count);
        return bv;
    }

    public synchronized InputRegister[] readInputRegisters(int ref, int count) throws ModbusException {
        this.m_ReadInputRegistersRequest.setReference(ref);
        this.m_ReadInputRegistersRequest.setWordCount(count);
        this.m_Transaction.setRequest(this.m_ReadInputRegistersRequest);
        this.m_Transaction.execute();
        return ((ReadInputRegistersResponse)this.m_Transaction.getResponse()).getRegisters();
    }

    public synchronized Register[] readMultipleRegisters(int ref, int count) throws ModbusException {
        this.m_ReadMultipleRegistersRequest.setReference(ref);
        this.m_ReadMultipleRegistersRequest.setWordCount(count);
        this.m_Transaction.setRequest(this.m_ReadMultipleRegistersRequest);
        this.m_Transaction.execute();
        return ((ReadMultipleRegistersResponse)this.m_Transaction.getResponse()).getRegisters();
    }

    public synchronized void writeSingleRegister(int ref, Register register) throws ModbusException {
        this.m_WriteSingleRegisterRequest.setReference(ref);
        this.m_WriteSingleRegisterRequest.setRegister(register);
        this.m_Transaction.setRequest(this.m_WriteSingleRegisterRequest);
        this.m_Transaction.execute();
    }

    public synchronized void writeMultipleRegisters(int ref, Register[] registers) throws ModbusException {
        this.m_WriteMultipleRegistersRequest.setReference(ref);
        this.m_WriteMultipleRegistersRequest.setRegisters(registers);
        this.m_Transaction.setRequest(this.m_WriteMultipleRegistersRequest);
        this.m_Transaction.execute();
    }
}

