/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.io;

import java.io.IOException;
import java.io.InputStream;

public class FastByteArrayInputStream
extends InputStream {
    protected int count;
    protected int pos;
    protected int mark;
    protected byte[] buf;

    public FastByteArrayInputStream(byte[] buffer) {
        this.buf = buffer;
        this.count = buffer.length;
        this.pos = 0;
        this.mark = 0;
    }

    public FastByteArrayInputStream(byte[] buffer, int offset, int length) {
        this.buf = buffer;
        this.pos = offset;
        this.count = length;
    }

    @Override
    public int available() {
        return this.count - this.pos;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readlimit) {
        this.mark = this.pos;
    }

    @Override
    public void reset() {
        this.pos = this.mark;
    }

    @Override
    public long skip(long count) {
        int myCount = (int)count;
        if (myCount + this.pos > this.count) {
            myCount = this.count - this.pos;
        }
        this.pos += myCount;
        return myCount;
    }

    @Override
    public int read() throws IOException {
        return this.pos < this.count ? this.buf[this.pos++] & 0xFF : -1;
    }

    @Override
    public int read(byte[] toBuf) throws IOException {
        return this.read(toBuf, 0, toBuf.length);
    }

    @Override
    public int read(byte[] toBuf, int offset, int length) throws IOException {
        int avail = this.count - this.pos;
        if (avail <= 0) {
            return -1;
        }
        if (length > avail) {
            length = avail;
        }
        int i = 0;
        while (i < length) {
            toBuf[offset++] = this.buf[this.pos++];
            ++i;
        }
        return length;
    }

    public byte[] toByteArray() {
        byte[] toBuf = new byte[this.count];
        System.arraycopy(this.buf, 0, toBuf, 0, this.count);
        return toBuf;
    }

    public byte[] getBufferBytes() {
        return this.buf;
    }

    public int getBufferOffset() {
        return this.pos;
    }

    public int getBufferLength() {
        return this.count;
    }
}

