/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.io;

import com.ghgande.j2mod.modbus.ModbusCoupler;
import com.ghgande.j2mod.modbus.ModbusIOException;
import com.ghgande.j2mod.modbus.io.ASCIIInputStream;
import com.ghgande.j2mod.modbus.io.ASCIIOutputStream;
import com.ghgande.j2mod.modbus.io.BytesInputStream;
import com.ghgande.j2mod.modbus.io.BytesOutputStream;
import com.ghgande.j2mod.modbus.io.ModbusSerialTransaction;
import com.ghgande.j2mod.modbus.io.ModbusSerialTransport;
import com.ghgande.j2mod.modbus.io.ModbusTransaction;
import com.ghgande.j2mod.modbus.msg.ModbusMessage;
import com.ghgande.j2mod.modbus.msg.ModbusRequest;
import com.ghgande.j2mod.modbus.msg.ModbusResponse;
import com.ghgande.j2mod.modbus.util.ModbusUtil;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ModbusASCIITransport
extends ModbusSerialTransport {
    private DataInputStream m_InputStream;
    private ASCIIOutputStream m_OutputStream;
    private byte[] m_InBuffer;
    private BytesInputStream m_ByteIn;
    private BytesOutputStream m_ByteInOut;
    private BytesOutputStream m_ByteOut;
    public static final int FRAME_START = 1000;
    public static final int FRAME_END = 2000;

    @Override
    public void close() throws IOException {
        this.m_InputStream.close();
        this.m_OutputStream.close();
    }

    @Override
    public ModbusTransaction createTransaction() {
        return new ModbusSerialTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeMessage(ModbusMessage msg) throws ModbusIOException {
        try {
            BytesOutputStream bytesOutputStream = this.m_ByteOut;
            synchronized (bytesOutputStream) {
                msg.setHeadless();
                msg.writeTo(this.m_ByteOut);
                byte[] buf = this.m_ByteOut.getBuffer();
                int len = this.m_ByteOut.size();
                this.m_OutputStream.write(1000);
                this.m_OutputStream.write(buf, 0, len);
                System.out.println("Writing: " + ModbusUtil.toHex(buf, 0, len));
                this.m_OutputStream.write(ModbusASCIITransport.calculateLRC(buf, 0, len));
                this.m_OutputStream.write(2000);
                this.m_OutputStream.flush();
                this.m_ByteOut.reset();
                if (this.m_Echo) {
                    this.readEcho(len + 3);
                }
            }
        }
        catch (Exception ex) {
            throw new ModbusIOException("I/O failed to write");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public ModbusRequest readRequest() throws ModbusIOException {
        boolean done = false;
        ModbusRequest request = null;
        int in = -1;
        try {
            while (true) {
                block11: {
                    if ((in = this.m_InputStream.read()) != 1000) {
                        continue;
                    }
                    byte[] byArray = this.m_InBuffer;
                    // MONITORENTER : this.m_InBuffer
                    this.m_ByteInOut.reset();
                    while (true) {
                        if ((in = this.m_InputStream.read()) == 2000) {
                            if (this.m_InBuffer[this.m_ByteInOut.size() - 1] == this.calculateLRC(this.m_InBuffer, 0, this.m_ByteInOut.size(), 1)) break;
                            // MONITOREXIT : byArray
                            break block11;
                        }
                        if (in == -1) {
                            throw new IOException("I/O exception - Serial port timeout.");
                        }
                        this.m_ByteInOut.writeByte(in);
                    }
                    this.m_ByteIn.reset(this.m_InBuffer, this.m_ByteInOut.size());
                    in = this.m_ByteIn.readUnsignedByte();
                    if (in != ModbusCoupler.getReference().getUnitID()) {
                        // MONITOREXIT : byArray
                        break block11;
                    }
                    in = this.m_ByteIn.readUnsignedByte();
                    request = ModbusRequest.createModbusRequest(in);
                    request.setHeadless();
                    this.m_ByteIn.reset(this.m_InBuffer, this.m_ByteInOut.size());
                    request.readFrom(this.m_ByteIn);
                    // MONITOREXIT : byArray
                    done = true;
                }
                if (done) return request;
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            throw new ModbusIOException("I/O exception - failed to read.");
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public ModbusResponse readResponse() throws ModbusIOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void prepareStreams(InputStream in, OutputStream out) throws IOException {
        this.m_InputStream = new DataInputStream(new ASCIIInputStream(in));
        this.m_OutputStream = new ASCIIOutputStream(out);
        this.m_ByteOut = new BytesOutputStream(256);
        this.m_InBuffer = new byte[256];
        this.m_ByteIn = new BytesInputStream(this.m_InBuffer);
        this.m_ByteInOut = new BytesOutputStream(this.m_InBuffer);
    }

    private static final int calculateLRC(byte[] data, int off, int len) {
        int lrc = 0;
        int i = off;
        while (i < len) {
            lrc += data[i] & 0xFF;
            ++i;
        }
        return -lrc & 0xFF;
    }

    private final byte calculateLRC(byte[] data, int off, int length, int tailskip) {
        int lrc = 0;
        int i = off;
        while (i < length - tailskip) {
            lrc += data[i] & 0xFF;
            ++i;
        }
        return (byte)(-lrc & 0xFF);
    }

    public boolean getDebug() {
        return "true".equals(System.getProperty("com.ghgande.j2mod.modbus.debug"));
    }
}

