/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.io;

import com.ghgande.j2mod.modbus.ModbusCoupler;
import com.ghgande.j2mod.modbus.ModbusIOException;
import com.ghgande.j2mod.modbus.io.ASCIIInputStream;
import com.ghgande.j2mod.modbus.io.ASCIIOutputStream;
import com.ghgande.j2mod.modbus.io.BytesInputStream;
import com.ghgande.j2mod.modbus.io.BytesOutputStream;
import com.ghgande.j2mod.modbus.io.ModbusSerialTransaction;
import com.ghgande.j2mod.modbus.io.ModbusSerialTransport;
import com.ghgande.j2mod.modbus.io.ModbusTransaction;
import com.ghgande.j2mod.modbus.msg.ModbusMessage;
import com.ghgande.j2mod.modbus.msg.ModbusRequest;
import com.ghgande.j2mod.modbus.msg.ModbusResponse;
import com.ghgande.j2mod.modbus.util.ModbusUtil;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ModbusBINTransport
extends ModbusSerialTransport {
    private DataInputStream m_InputStream;
    private ASCIIOutputStream m_OutputStream;
    private byte[] m_InBuffer;
    private BytesInputStream m_ByteIn;
    private BytesOutputStream m_ByteInOut;
    private BytesOutputStream m_ByteOut;
    public static final int FRAME_START = 1000;
    public static final int FRAME_END = 2000;
    public static final int FRAME_START_TOKEN = 123;
    public static final int FRAME_END_TOKEN = 125;

    @Override
    public void close() throws IOException {
        this.m_InputStream.close();
        this.m_OutputStream.close();
    }

    @Override
    public ModbusTransaction createTransaction() {
        return new ModbusSerialTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeMessage(ModbusMessage msg) throws ModbusIOException {
        try {
            int len;
            BytesOutputStream bytesOutputStream = this.m_ByteOut;
            synchronized (bytesOutputStream) {
                msg.setHeadless();
                msg.writeTo(this.m_ByteOut);
                byte[] buf = this.m_ByteOut.getBuffer();
                len = this.m_ByteOut.size();
                this.m_OutputStream.write(1000);
                this.m_OutputStream.write(buf, 0, len);
                int[] crc = ModbusUtil.calculateCRC(buf, 0, len);
                this.m_OutputStream.write(crc[0]);
                this.m_OutputStream.write(crc[1]);
                this.m_OutputStream.write(2000);
                this.m_OutputStream.flush();
                this.m_ByteOut.reset();
            }
            if (this.m_Echo) {
                this.readEcho(len + 4);
            }
        }
        catch (Exception ex) {
            throw new ModbusIOException("I/O failed to write");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public ModbusRequest readRequest() throws ModbusIOException {
        boolean done = false;
        ModbusRequest request = null;
        int in = -1;
        try {
            while (true) {
                block10: {
                    if ((in = this.m_InputStream.read()) != 1000) {
                        continue;
                    }
                    byte[] byArray = this.m_InBuffer;
                    // MONITORENTER : this.m_InBuffer
                    this.m_ByteInOut.reset();
                    while (true) {
                        if ((in = this.m_InputStream.read()) == 2000) {
                            int[] crc = ModbusUtil.calculateCRC(this.m_InBuffer, 0, this.m_ByteInOut.size() - 2);
                            if (this.m_InBuffer[this.m_ByteInOut.size() - 2] == crc[0] && this.m_InBuffer[this.m_ByteInOut.size() - 1] == crc[1]) break;
                            // MONITOREXIT : byArray
                            break block10;
                        }
                        this.m_ByteInOut.writeByte(in);
                    }
                    this.m_ByteIn.reset(this.m_InBuffer, this.m_ByteInOut.size());
                    in = this.m_ByteIn.readUnsignedByte();
                    if (in != ModbusCoupler.getReference().getUnitID()) {
                        // MONITOREXIT : byArray
                        break block10;
                    }
                    in = this.m_ByteIn.readUnsignedByte();
                    request = ModbusRequest.createModbusRequest(in);
                    request.setHeadless();
                    this.m_ByteIn.reset(this.m_InBuffer, this.m_ByteInOut.size());
                    request.readFrom(this.m_ByteIn);
                    // MONITOREXIT : byArray
                    done = true;
                }
                if (done) return request;
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            throw new ModbusIOException("I/O exception - failed to read.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public ModbusResponse readResponse() throws ModbusIOException {
        boolean done = false;
        ModbusResponse response = null;
        int in = -1;
        try {
            while (true) {
                block11: {
                    if ((in = this.m_InputStream.read()) != 1000) {
                        continue;
                    }
                    byte[] byArray = this.m_InBuffer;
                    // MONITORENTER : this.m_InBuffer
                    this.m_ByteInOut.reset();
                    while (true) {
                        if ((in = this.m_InputStream.read()) == 2000) {
                            int[] crc = ModbusUtil.calculateCRC(this.m_InBuffer, 0, this.m_ByteInOut.size() - 2);
                            if (this.m_InBuffer[this.m_ByteInOut.size() - 2] == crc[0] && this.m_InBuffer[this.m_ByteInOut.size() - 1] == crc[1]) break;
                            // MONITOREXIT : byArray
                            break block11;
                        }
                        this.m_ByteInOut.writeByte(in);
                    }
                    this.m_ByteIn.reset(this.m_InBuffer, this.m_ByteInOut.size());
                    in = this.m_ByteIn.readUnsignedByte();
                    if (in != ModbusCoupler.getReference().getUnitID()) {
                        // MONITOREXIT : byArray
                        break block11;
                    }
                    this.m_ByteIn.reset(this.m_InBuffer, this.m_ByteInOut.size());
                    in = this.m_ByteIn.readUnsignedByte();
                    if (in != ModbusCoupler.getReference().getUnitID()) {
                        // MONITOREXIT : byArray
                        break block11;
                    }
                    in = this.m_ByteIn.readUnsignedByte();
                    response = ModbusResponse.createModbusResponse(in);
                    response.setHeadless();
                    this.m_ByteIn.reset(this.m_InBuffer, this.m_ByteInOut.size());
                    response.readFrom(this.m_ByteIn);
                    // MONITOREXIT : byArray
                    done = true;
                }
                if (done) return response;
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            throw new ModbusIOException("I/O exception - failed to read.");
        }
    }

    @Override
    public void prepareStreams(InputStream in, OutputStream out) throws IOException {
        this.m_InputStream = new DataInputStream(new ASCIIInputStream(in));
        this.m_OutputStream = new ASCIIOutputStream(out);
        this.m_ByteOut = new BytesOutputStream(256);
        this.m_InBuffer = new byte[256];
        this.m_ByteIn = new BytesInputStream(this.m_InBuffer);
        this.m_ByteInOut = new BytesOutputStream(this.m_InBuffer);
    }
}

