/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.io;

import com.ghgande.j2mod.modbus.ModbusCoupler;
import com.ghgande.j2mod.modbus.ModbusIOException;
import com.ghgande.j2mod.modbus.io.BytesInputStream;
import com.ghgande.j2mod.modbus.io.BytesOutputStream;
import com.ghgande.j2mod.modbus.io.ModbusSerialTransaction;
import com.ghgande.j2mod.modbus.io.ModbusSerialTransport;
import com.ghgande.j2mod.modbus.io.ModbusTransaction;
import com.ghgande.j2mod.modbus.msg.ModbusMessage;
import com.ghgande.j2mod.modbus.msg.ModbusRequest;
import com.ghgande.j2mod.modbus.msg.ModbusResponse;
import com.ghgande.j2mod.modbus.util.ModbusUtil;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ModbusRTUTransport
extends ModbusSerialTransport {
    private InputStream m_InputStream;
    private OutputStream m_OutputStream;
    private byte[] m_InBuffer;
    private BytesInputStream m_ByteIn;
    private BytesOutputStream m_ByteInOut;
    private BytesOutputStream m_ByteOut;
    private byte[] lastRequest = null;
    private boolean osIsKnown = false;
    private boolean osIsWindows = false;

    public void clearInput() throws IOException {
        if (this.m_InputStream.available() > 0) {
            int len = this.m_InputStream.available();
            byte[] buf = new byte[len];
            this.m_InputStream.read(buf, 0, len);
            System.err.println("Clear input: " + ModbusUtil.toHex(buf, 0, len));
        }
    }

    @Override
    public void close() throws IOException {
        this.m_InputStream.close();
        this.m_OutputStream.close();
    }

    @Override
    public ModbusTransaction createTransaction() {
        ModbusSerialTransaction transaction = new ModbusSerialTransaction();
        transaction.setTransport(this);
        return transaction;
    }

    private void getRequest(int function, BytesOutputStream out) throws IOException {
        int byteCount = -1;
        byte[] inpBuf = new byte[256];
        int tmOut = this.m_CommPort.getReceiveTimeout();
        if (tmOut == 0) {
            try {
                this.m_CommPort.enableReceiveTimeout(250);
            }
            catch (UnsupportedCommOperationException unsupportedCommOperationException) {
                // empty catch block
            }
        }
        if (!this.osIsKnown) {
            String osName = System.getProperty("os.name");
            if (osName.toLowerCase().startsWith("win")) {
                this.osIsWindows = true;
            }
            this.osIsKnown = true;
        }
        try {
            if ((function & 0x80) == 0) {
                switch (function) {
                    case 7: 
                    case 11: 
                    case 12: 
                    case 17: {
                        this.readRequestData(0, inpBuf, out);
                        break;
                    }
                    case 24: {
                        this.readRequestData(2, inpBuf, out);
                        break;
                    }
                    case 43: {
                        this.readRequestData(3, inpBuf, out);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        this.readRequestData(4, inpBuf, out);
                        break;
                    }
                    case 22: {
                        this.readRequestData(6, inpBuf, out);
                        break;
                    }
                    case 20: 
                    case 21: {
                        byteCount = this.m_InputStream.read();
                        out.write(byteCount);
                        this.readRequestData(byteCount, inpBuf, out);
                        break;
                    }
                    case 15: 
                    case 16: {
                        byteCount = this.m_InputStream.read(inpBuf, 0, 4);
                        if (byteCount > 0) {
                            out.write(inpBuf, 0, byteCount);
                        }
                        byteCount = this.m_InputStream.read();
                        out.write(byteCount);
                        this.readRequestData(byteCount, inpBuf, out);
                        break;
                    }
                    case 23: {
                        this.readRequestData(8, inpBuf, out);
                        byteCount = this.m_InputStream.read();
                        out.write(byteCount);
                        this.readRequestData(byteCount, inpBuf, out);
                    }
                    default: {
                        break;
                    }
                }
            }
        }
        catch (IOException e) {
            this.m_CommPort.disableReceiveThreshold();
            throw new IOException("getResponse serial port exception");
        }
        if (tmOut == 0) {
            this.m_CommPort.disableReceiveTimeout();
        }
    }

    private void getResponse(int function, BytesOutputStream out) throws IOException {
        int byteCount = -1;
        int readCount = 0;
        byte[] inpBuf = new byte[256];
        int tmOut = this.m_CommPort.getReceiveTimeout();
        long timedOut = System.currentTimeMillis() + (long)tmOut;
        if (tmOut == 0) {
            try {
                this.m_CommPort.enableReceiveTimeout(250);
                timedOut += 250L;
            }
            catch (UnsupportedCommOperationException unsupportedCommOperationException) {
                // empty catch block
            }
        }
        if (!this.osIsKnown) {
            String osName = System.getProperty("os.name");
            if (osName.toLowerCase().startsWith("win")) {
                this.osIsWindows = true;
            }
            this.osIsKnown = true;
        }
        try {
            if ((function & 0x80) == 0) {
                switch (function) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 12: 
                    case 17: 
                    case 20: 
                    case 21: 
                    case 23: {
                        byteCount = this.m_InputStream.read();
                        out.write(byteCount);
                        int remaining = byteCount + 2;
                        int read = 0;
                        int loopCount = 0;
                        while (remaining > 0 && loopCount++ < 5) {
                            if (!this.osIsWindows) {
                                this.setReceiveThreshold(remaining);
                            } else {
                                this.setReceiveThreshold(remaining > 16 ? 16 : remaining);
                            }
                            readCount = this.m_InputStream.read(inpBuf, 0, remaining);
                            if (readCount > 0) {
                                out.write(inpBuf, 0, readCount);
                                read += readCount;
                                remaining -= readCount;
                                loopCount = 0;
                            }
                            if (readCount == 0 && System.currentTimeMillis() > timedOut) break;
                            if (remaining <= 0) continue;
                            Thread.yield();
                        }
                        if (remaining > 0) {
                            System.err.println("Error: looking for " + (byteCount + 2) + " bytes, received " + read);
                        }
                        this.m_CommPort.disableReceiveThreshold();
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 8: 
                    case 11: 
                    case 15: 
                    case 16: {
                        this.setReceiveThreshold(6);
                        readCount = this.m_InputStream.read(inpBuf, 0, 6);
                        out.write(inpBuf, 0, readCount);
                        this.m_CommPort.disableReceiveThreshold();
                        break;
                    }
                    case 7: {
                        this.setReceiveThreshold(3);
                        readCount = this.m_InputStream.read(inpBuf, 0, 3);
                        out.write(inpBuf, 0, readCount);
                        this.m_CommPort.disableReceiveThreshold();
                        break;
                    }
                    case 22: {
                        this.setReceiveThreshold(8);
                        readCount = this.m_InputStream.read(inpBuf, 0, 8);
                        out.write(inpBuf, 0, readCount);
                        this.m_CommPort.disableReceiveThreshold();
                        break;
                    }
                    case 24: {
                        byte b1 = (byte)(this.m_InputStream.read() & 0xFF);
                        out.write(b1);
                        byte b2 = (byte)(this.m_InputStream.read() & 0xFF);
                        out.write(b2);
                        byteCount = ModbusUtil.makeWord(b1, b2);
                        this.setReceiveThreshold(byteCount + 2);
                        readCount = this.m_InputStream.read(inpBuf, 0, byteCount + 2);
                        out.write(inpBuf, 0, readCount);
                        this.m_CommPort.disableReceiveThreshold();
                        break;
                    }
                    case 43: {
                        int sc = this.m_InputStream.read();
                        if (sc != 14) {
                            throw new IOException("Invalid subfunction code");
                        }
                        out.write(sc);
                        this.setReceiveThreshold(5);
                        int cnt = this.m_InputStream.read(inpBuf, 0, 5);
                        out.write(inpBuf, 0, cnt);
                        int id = inpBuf[0];
                        int fieldCount = inpBuf[4];
                        int i = 0;
                        while (i < fieldCount) {
                            this.setReceiveThreshold(1);
                            id = this.m_InputStream.read();
                            out.write(id);
                            int len = this.m_InputStream.read();
                            out.write(len);
                            this.setReceiveThreshold(len);
                            len = this.m_InputStream.read(inpBuf, 0, len);
                            out.write(inpBuf, 0, len);
                            ++i;
                        }
                        if (fieldCount == 0) {
                            this.setReceiveThreshold(1);
                            int err = this.m_InputStream.read();
                            out.write(err);
                        }
                        this.setReceiveThreshold(2);
                        readCount = this.m_InputStream.read(inpBuf, 0, 2);
                        out.write(inpBuf, 0, 2);
                        this.m_CommPort.disableReceiveThreshold();
                        this.m_CommPort.disableReceiveTimeout();
                    }
                }
            } else {
                this.setReceiveThreshold(3);
                readCount = this.m_InputStream.read(inpBuf, 0, 3);
                out.write(inpBuf, 0, 3);
                this.m_CommPort.disableReceiveThreshold();
            }
        }
        catch (IOException e) {
            this.m_CommPort.disableReceiveThreshold();
            throw new IOException("getResponse serial port exception");
        }
        if (tmOut == 0) {
            this.m_CommPort.disableReceiveTimeout();
        }
    }

    @Override
    public void prepareStreams(InputStream in, OutputStream out) throws IOException {
        this.m_InputStream = in;
        this.m_OutputStream = out;
        this.m_ByteOut = new BytesOutputStream(256);
        this.m_InBuffer = new byte[256];
        this.m_ByteIn = new BytesInputStream(this.m_InBuffer);
        this.m_ByteInOut = new BytesOutputStream(this.m_InBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModbusRequest readRequest() throws ModbusIOException {
        ModbusCoupler coupler = ModbusCoupler.getReference();
        if (coupler == null || coupler.isMaster()) {
            throw new RuntimeException("Operation not supported.");
        }
        boolean done = false;
        ModbusRequest request = null;
        int dlength = 0;
        try {
            do {
                BytesInputStream bytesInputStream = this.m_ByteIn;
                synchronized (bytesInputStream) {
                    int uid = this.m_InputStream.read();
                    if (uid != -1) {
                        int fc = this.m_InputStream.read();
                        this.m_ByteInOut.reset();
                        this.m_ByteInOut.writeByte(uid);
                        this.m_ByteInOut.writeByte(fc);
                        request = ModbusRequest.createModbusRequest(fc);
                        request.setHeadless();
                        this.getRequest(fc, this.m_ByteInOut);
                        dlength = this.m_ByteInOut.size() - 2;
                        System.err.println("Response: " + ModbusUtil.toHex(this.m_ByteInOut.getBuffer(), 0, dlength + 2));
                        this.m_ByteIn.reset(this.m_InBuffer, dlength);
                        int[] crc = ModbusUtil.calculateCRC(this.m_InBuffer, 0, dlength);
                        if (ModbusUtil.unsignedByteToInt(this.m_InBuffer[dlength]) != crc[0] && ModbusUtil.unsignedByteToInt(this.m_InBuffer[dlength + 1]) != crc[1]) {
                            System.err.println("CRC should be " + crc[0] + ", " + crc[1]);
                            this.clearInput();
                            throw new IOException("CRC Error in received frame: " + dlength + " bytes: " + ModbusUtil.toHex(this.m_ByteIn.getBuffer(), 0, dlength));
                        }
                    } else {
                        throw new IOException("Error reading response");
                    }
                    this.m_ByteIn.reset(this.m_InBuffer, dlength);
                    if (request != null) {
                        request.readFrom(this.m_ByteIn);
                    }
                    done = true;
                }
            } while (!done);
            return request;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private void readRequestData(int byteCount, byte[] inpBuf, BytesOutputStream out) throws IOException {
        int remaining = byteCount + 2;
        int read = 0;
        int loopCount = 0;
        int tmOut = this.m_CommPort.getReceiveTimeout();
        long timedOut = System.currentTimeMillis() + (long)tmOut;
        if (tmOut == 0) {
            try {
                this.m_CommPort.enableReceiveTimeout(250);
                timedOut += 250L;
            }
            catch (UnsupportedCommOperationException unsupportedCommOperationException) {
                // empty catch block
            }
        }
        if (!this.osIsWindows) {
            this.setReceiveThreshold(remaining);
        } else {
            this.setReceiveThreshold(remaining > 16 ? 16 : remaining);
        }
        while (remaining > 0 && loopCount++ < 5) {
            int readCount = this.m_InputStream.read(inpBuf, 0, remaining);
            if (readCount > 0) {
                out.write(inpBuf, 0, readCount);
                read += readCount;
                loopCount = 0;
                if (this.osIsWindows && (remaining -= readCount) > 0 && remaining < 16) {
                    this.setReceiveThreshold(remaining);
                }
            }
            if (readCount == 0 && System.currentTimeMillis() > timedOut) break;
            if (remaining <= 0 || this.osIsWindows && readCount == 16) continue;
            Thread.yield();
        }
        if (remaining > 0) {
            System.err.println("Error: looking for " + (byteCount + 2) + " bytes, received " + read);
        }
        this.m_CommPort.disableReceiveThreshold();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModbusResponse readResponse() throws ModbusIOException {
        boolean done = false;
        ModbusResponse response = null;
        int dlength = 0;
        try {
            do {
                BytesInputStream bytesInputStream = this.m_ByteIn;
                synchronized (bytesInputStream) {
                    int uid = this.m_InputStream.read();
                    if (uid != -1) {
                        int fc = this.m_InputStream.read();
                        this.m_ByteInOut.reset();
                        this.m_ByteInOut.writeByte(uid);
                        this.m_ByteInOut.writeByte(fc);
                        response = ModbusResponse.createModbusResponse(fc);
                        response.setHeadless();
                        this.getResponse(fc, this.m_ByteInOut);
                        dlength = this.m_ByteInOut.size() - 2;
                        System.err.println("Response: " + ModbusUtil.toHex(this.m_ByteInOut.getBuffer(), 0, dlength + 2));
                        this.m_ByteIn.reset(this.m_InBuffer, dlength);
                        int[] crc = ModbusUtil.calculateCRC(this.m_InBuffer, 0, dlength);
                        if (ModbusUtil.unsignedByteToInt(this.m_InBuffer[dlength]) != crc[0] && ModbusUtil.unsignedByteToInt(this.m_InBuffer[dlength + 1]) != crc[1]) {
                            System.err.println("CRC should be " + crc[0] + ", " + crc[1]);
                            throw new IOException("CRC Error in received frame: " + dlength + " bytes: " + ModbusUtil.toHex(this.m_ByteIn.getBuffer(), 0, dlength));
                        }
                    } else {
                        throw new IOException("Error reading response");
                    }
                    this.m_ByteIn.reset(this.m_InBuffer, dlength);
                    if (response != null) {
                        response.readFrom(this.m_ByteIn);
                    }
                    done = true;
                }
            } while (!done);
            return response;
        }
        catch (Exception ex) {
            System.err.println("Last request: " + ModbusUtil.toHex(this.lastRequest));
            System.err.println(ex.getMessage());
            throw new ModbusIOException("I/O exception - failed to read");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeMessage(ModbusMessage msg) throws ModbusIOException {
        try {
            BytesOutputStream bytesOutputStream = this.m_ByteOut;
            synchronized (bytesOutputStream) {
                this.clearInput();
                this.m_ByteOut.reset();
                msg.setHeadless();
                msg.writeTo(this.m_ByteOut);
                int len = this.m_ByteOut.size();
                int[] crc = ModbusUtil.calculateCRC(this.m_ByteOut.getBuffer(), 0, len);
                this.m_ByteOut.writeByte(crc[0]);
                this.m_ByteOut.writeByte(crc[1]);
                len = this.m_ByteOut.size();
                byte[] buf = this.m_ByteOut.getBuffer();
                this.m_OutputStream.write(buf, 0, len);
                this.m_OutputStream.flush();
                System.err.println("Sent: " + ModbusUtil.toHex(buf, 0, len));
                if (this.m_Echo) {
                    this.readEcho(len);
                }
                this.lastRequest = new byte[len];
                System.arraycopy(buf, 0, this.lastRequest, 0, len);
            }
        }
        catch (Exception ex) {
            throw new ModbusIOException("I/O failed to write");
        }
    }
}

