/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.io;

import com.ghgande.j2mod.modbus.ModbusException;
import com.ghgande.j2mod.modbus.ModbusIOException;
import com.ghgande.j2mod.modbus.ModbusSlaveException;
import com.ghgande.j2mod.modbus.io.ModbusSerialTransport;
import com.ghgande.j2mod.modbus.io.ModbusTransaction;
import com.ghgande.j2mod.modbus.io.ModbusTransport;
import com.ghgande.j2mod.modbus.msg.ExceptionResponse;
import com.ghgande.j2mod.modbus.msg.ModbusRequest;
import com.ghgande.j2mod.modbus.msg.ModbusResponse;
import com.ghgande.j2mod.modbus.net.SerialConnection;

public class ModbusSerialTransaction
implements ModbusTransaction {
    private static int c_TransactionID = 0;
    private ModbusTransport m_IO;
    private ModbusRequest m_Request;
    private ModbusResponse m_Response;
    private boolean m_ValidityCheck = true;
    private int m_Retries = 3;
    private int m_TransDelayMS = 0;
    private SerialConnection m_SerialCon;

    public ModbusSerialTransaction() {
    }

    public ModbusSerialTransaction(ModbusRequest request) {
        this.setRequest(request);
    }

    public ModbusSerialTransaction(SerialConnection con) {
        this.setSerialConnection(con);
    }

    public void setSerialConnection(SerialConnection con) {
        this.m_SerialCon = con;
        this.m_IO = this.m_SerialCon.getModbusTransport();
    }

    public void setTransport(ModbusSerialTransport transport) {
        this.m_IO = transport;
    }

    @Override
    public int getTransactionID() {
        return c_TransactionID;
    }

    @Override
    public void setRequest(ModbusRequest req) {
        this.m_Request = req;
    }

    @Override
    public ModbusRequest getRequest() {
        return this.m_Request;
    }

    @Override
    public ModbusResponse getResponse() {
        return this.m_Response;
    }

    @Override
    public void setCheckingValidity(boolean b) {
        this.m_ValidityCheck = b;
    }

    @Override
    public boolean isCheckingValidity() {
        return this.m_ValidityCheck;
    }

    @Override
    public int getRetries() {
        return this.m_Retries;
    }

    @Override
    public void setRetries(int num) {
        this.m_Retries = num;
    }

    public int getTransDelayMS() {
        return this.m_TransDelayMS;
    }

    public void setTransDelayMS(int newTransDelayMS) {
        this.m_TransDelayMS = newTransDelayMS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws ModbusIOException, ModbusSlaveException, ModbusException {
        this.assertExecutable();
        ModbusTransport modbusTransport = this.m_IO;
        synchronized (modbusTransport) {
            int tries = 0;
            boolean finished = false;
            do {
                try {
                    if (this.m_TransDelayMS > 0) {
                        try {
                            Thread.sleep(this.m_TransDelayMS);
                        }
                        catch (InterruptedException ex) {
                            System.err.println("InterruptedException: " + ex.getMessage());
                        }
                    }
                    this.m_IO.writeMessage(this.m_Request);
                    this.m_Response = this.m_IO.readResponse();
                    finished = true;
                }
                catch (ModbusIOException e) {
                    if (++tries >= this.m_Retries) {
                        throw e;
                    }
                    System.err.println("Execute try " + tries + " error: " + e.getMessage());
                }
            } while (!finished);
        }
        if (this.m_Response instanceof ExceptionResponse) {
            throw new ModbusSlaveException(((ExceptionResponse)this.m_Response).getExceptionCode());
        }
        if (this.isCheckingValidity()) {
            this.checkValidity();
        }
        this.toggleTransactionID();
    }

    private void assertExecutable() throws ModbusException {
        if (this.m_Request == null || this.m_IO == null) {
            throw new ModbusException("Assertion failed, transaction not executable");
        }
    }

    private void checkValidity() throws ModbusException {
    }

    private void toggleTransactionID() {
        if (this.isCheckingValidity()) {
            c_TransactionID = c_TransactionID == 65534 ? 0 : ++c_TransactionID;
        }
        this.m_Request.setTransactionID(this.getTransactionID());
    }
}

