/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.io;

import com.ghgande.j2mod.modbus.ModbusIOException;
import com.ghgande.j2mod.modbus.io.ModbusTransport;
import com.ghgande.j2mod.modbus.msg.ModbusMessage;
import com.ghgande.j2mod.modbus.msg.ModbusRequest;
import com.ghgande.j2mod.modbus.msg.ModbusResponse;
import com.ghgande.j2mod.modbus.util.ModbusUtil;
import gnu.io.CommPort;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class ModbusSerialTransport
implements ModbusTransport {
    protected CommPort m_CommPort;
    protected boolean m_Echo = false;

    public abstract void prepareStreams(InputStream var1, OutputStream var2) throws IOException;

    @Override
    public abstract ModbusResponse readResponse() throws ModbusIOException;

    @Override
    public abstract ModbusRequest readRequest() throws ModbusIOException;

    @Override
    public abstract void writeMessage(ModbusMessage var1) throws ModbusIOException;

    @Override
    public abstract void close() throws IOException;

    public void setCommPort(CommPort cp) throws IOException {
        this.m_CommPort = cp;
        if (cp != null) {
            this.prepareStreams(cp.getInputStream(), cp.getOutputStream());
        }
    }

    public boolean isEcho() {
        return this.m_Echo;
    }

    public void setEcho(boolean b) {
        this.m_Echo = b;
    }

    public void setReceiveThreshold(int th) {
        try {
            this.m_CommPort.enableReceiveThreshold(th);
        }
        catch (UnsupportedCommOperationException e) {
            System.out.println(e.getMessage());
        }
    }

    public void setReceiveTimeout(int ms) {
        try {
            this.m_CommPort.enableReceiveTimeout(ms);
            int thresh = this.m_CommPort.getReceiveThreshold();
            if (thresh <= 0) {
                this.m_CommPort.enableReceiveThreshold(2);
            }
        }
        catch (UnsupportedCommOperationException e) {
            System.out.println(e.getMessage());
        }
    }

    public void setBaudRate(int baud) {
        try {
            SerialPort physicalPort = null;
            if (!(this.m_CommPort instanceof SerialPort)) {
                throw new UnsupportedCommOperationException("Cannot change baud rate on non-serial device.");
            }
            physicalPort = (SerialPort)this.m_CommPort;
            int stop = physicalPort.getStopBits();
            int data = physicalPort.getDataBits();
            int parity = physicalPort.getParity();
            physicalPort.setSerialPortParams(baud, data, stop, parity);
            System.err.println("baud rate is now " + physicalPort.getBaudRate());
        }
        catch (UnsupportedCommOperationException x) {
            System.out.println(x.getMessage());
        }
    }

    public void readEcho(int len) throws IOException {
        byte[] echoBuf = new byte[len];
        this.setReceiveThreshold(len);
        int echoLen = this.m_CommPort.getInputStream().read(echoBuf, 0, len);
        System.out.println("Echo: " + ModbusUtil.toHex(echoBuf, 0, echoLen));
        this.m_CommPort.disableReceiveThreshold();
        if (echoLen != len) {
            System.err.println("Error: Transmit echo not received.");
            throw new IOException("Echo not received.");
        }
    }
}

