/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.io;

import com.ghgande.j2mod.modbus.ModbusException;
import com.ghgande.j2mod.modbus.ModbusIOException;
import com.ghgande.j2mod.modbus.ModbusSlaveException;
import com.ghgande.j2mod.modbus.io.ModbusTransaction;
import com.ghgande.j2mod.modbus.io.ModbusTransport;
import com.ghgande.j2mod.modbus.msg.ExceptionResponse;
import com.ghgande.j2mod.modbus.msg.ModbusRequest;
import com.ghgande.j2mod.modbus.msg.ModbusResponse;
import com.ghgande.j2mod.modbus.net.TCPMasterConnection;

public class ModbusTCPTransaction
implements ModbusTransaction {
    private static int c_TransactionID = 0;
    private TCPMasterConnection m_Connection;
    private ModbusTransport m_IO;
    private ModbusRequest m_Request;
    private ModbusResponse m_Response;
    private boolean m_ValidityCheck = true;
    private boolean m_Reconnecting = false;
    private int m_Retries = 3;

    public ModbusTCPTransaction() {
    }

    public ModbusTCPTransaction(ModbusRequest request) {
        this.setRequest(request);
    }

    public ModbusTCPTransaction(TCPMasterConnection con) {
        this.setConnection(con);
        this.m_IO = con.getModbusTransport();
    }

    public void setConnection(TCPMasterConnection con) {
        this.m_Connection = con;
        this.m_IO = con.getModbusTransport();
    }

    @Override
    public void setRequest(ModbusRequest req) {
        this.m_Request = req;
    }

    @Override
    public ModbusRequest getRequest() {
        return this.m_Request;
    }

    @Override
    public ModbusResponse getResponse() {
        return this.m_Response;
    }

    @Override
    public int getTransactionID() {
        if (c_TransactionID <= 0 && this.isCheckingValidity()) {
            c_TransactionID = 1;
        }
        if (c_TransactionID >= Short.MAX_VALUE) {
            c_TransactionID = 1;
        }
        return c_TransactionID;
    }

    @Override
    public void setCheckingValidity(boolean b) {
        this.m_ValidityCheck = b;
    }

    @Override
    public boolean isCheckingValidity() {
        return this.m_ValidityCheck;
    }

    public void setReconnecting(boolean b) {
        this.m_Reconnecting = b;
    }

    public boolean isReconnecting() {
        return this.m_Reconnecting;
    }

    @Override
    public int getRetries() {
        return this.m_Retries;
    }

    @Override
    public void setRetries(int num) {
        this.m_Retries = num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws ModbusIOException, ModbusSlaveException, ModbusException {
        if (this.m_Request == null || this.m_Connection == null) {
            throw new ModbusException("Invalid request or connection");
        }
        if (!this.m_Connection.isConnected()) {
            try {
                this.m_Connection.connect();
            }
            catch (Exception ex) {
                throw new ModbusIOException("Connection failed.");
            }
        }
        int retryCounter = 0;
        int retryLimit = this.m_Retries > 0 ? this.m_Retries : 1;
        while (retryCounter < retryLimit) {
            try {
                ModbusTransport modbusTransport = this.m_IO;
                synchronized (modbusTransport) {
                    System.err.println("request transaction ID = " + this.m_Request.getTransactionID());
                    this.m_IO.writeMessage(this.m_Request);
                    this.m_Response = null;
                    do {
                        this.m_Response = this.m_IO.readResponse();
                        System.err.println("response transaction ID = " + this.m_Response.getTransactionID());
                        if (this.m_Response.getTransactionID() == this.m_Request.getTransactionID()) continue;
                        System.err.println("expected " + this.m_Request.getTransactionID() + ", got " + this.m_Response.getTransactionID());
                    } while (this.m_Response != null && (!this.isCheckingValidity() || this.m_Request.getTransactionID() != 0 && this.m_Request.getTransactionID() != this.m_Response.getTransactionID()) && ++retryCounter < retryLimit);
                    if (retryCounter >= retryLimit) {
                        throw new ModbusIOException("Executing transaction failed (tried " + this.m_Retries + " times)");
                    }
                    break;
                }
            }
            catch (ModbusIOException ex) {
                if (!this.m_Connection.isConnected()) {
                    try {
                        this.m_Connection.connect();
                    }
                    catch (Exception e) {
                        throw new ModbusIOException("Connection lost.");
                    }
                }
                if (retryCounter >= retryLimit) {
                    throw new ModbusIOException("Executing transaction failed (tried " + this.m_Retries + " times)");
                }
                ++retryCounter;
            }
        }
        if (this.m_Response instanceof ExceptionResponse) {
            throw new ModbusSlaveException(((ExceptionResponse)this.m_Response).getExceptionCode());
        }
        if (this.isReconnecting()) {
            this.m_Connection.close();
        }
        if (this.isCheckingValidity() && this.m_Request != null && this.m_Response != null) {
            this.checkValidity();
        }
        this.incrementTransactionID();
    }

    private void checkValidity() throws ModbusException {
        if (this.m_Request.getTransactionID() == 0 || this.m_Response.getTransactionID() == 0) {
            return;
        }
        if (this.m_Request.getTransactionID() != this.m_Response.getTransactionID()) {
            throw new ModbusException("Transaction ID mismatch");
        }
    }

    private void incrementTransactionID() {
        if (this.isCheckingValidity()) {
            c_TransactionID = c_TransactionID >= Short.MAX_VALUE ? 1 : ++c_TransactionID;
        }
        this.m_Request.setTransactionID(this.getTransactionID());
    }
}

