/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.io;

import com.ghgande.j2mod.modbus.ModbusIOException;
import com.ghgande.j2mod.modbus.io.BytesInputStream;
import com.ghgande.j2mod.modbus.io.BytesOutputStream;
import com.ghgande.j2mod.modbus.io.ModbusTCPTransaction;
import com.ghgande.j2mod.modbus.io.ModbusTransaction;
import com.ghgande.j2mod.modbus.io.ModbusTransport;
import com.ghgande.j2mod.modbus.msg.ModbusMessage;
import com.ghgande.j2mod.modbus.msg.ModbusRequest;
import com.ghgande.j2mod.modbus.msg.ModbusResponse;
import com.ghgande.j2mod.modbus.net.TCPMasterConnection;
import com.ghgande.j2mod.modbus.util.ModbusUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;

public class ModbusTCPTransport
implements ModbusTransport {
    private DataInputStream m_Input;
    private DataOutputStream m_Output;
    private BytesInputStream m_ByteIn;
    private BytesOutputStream m_ByteOut;
    private int m_Timeout = 3000;
    private Socket m_Socket = null;
    private TCPMasterConnection m_Master = null;
    private boolean headless = false;

    public void setSocket(Socket socket) throws IOException {
        if (this.m_Socket != null) {
            this.m_Socket.close();
            this.m_Socket = null;
        }
        this.m_Socket = socket;
        this.setTimeout(this.m_Timeout);
        this.prepareStreams(socket);
    }

    public void setHeadless() {
        this.headless = true;
    }

    public void setTimeout(int time) {
        this.m_Timeout = time;
        if (this.m_Socket != null) {
            try {
                this.m_Socket.setSoTimeout(time);
            }
            catch (SocketException e) {
                return;
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.m_Input.close();
        this.m_Output.close();
        this.m_Socket.close();
    }

    @Override
    public ModbusTransaction createTransaction() {
        if (this.m_Master == null) {
            this.m_Master = new TCPMasterConnection(this.m_Socket.getInetAddress());
            this.m_Master.setPort(this.m_Socket.getPort());
            this.m_Master.setModbusTransport(this);
        }
        ModbusTCPTransaction trans = new ModbusTCPTransaction(this.m_Master);
        return trans;
    }

    @Override
    public void writeMessage(ModbusMessage msg) throws ModbusIOException {
        try {
            byte[] message = msg.getMessage();
            this.m_ByteOut.reset();
            if (!this.headless) {
                this.m_ByteOut.writeShort(msg.getTransactionID());
                this.m_ByteOut.writeShort(msg.getProtocolID());
                this.m_ByteOut.writeShort((message != null ? message.length : 0) + 2);
            }
            this.m_ByteOut.writeByte(msg.getUnitID());
            this.m_ByteOut.writeByte(msg.getFunctionCode());
            if (message != null && message.length > 0) {
                this.m_ByteOut.write(message);
            }
            this.m_Output.write(this.m_ByteOut.toByteArray());
            this.m_Output.flush();
            System.err.println("Sent: " + ModbusUtil.toHex(this.m_ByteOut.toByteArray()));
        }
        catch (SocketException ex) {
            if (!this.m_Master.isConnected()) {
                try {
                    this.m_Master.connect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new ModbusIOException("I/O exception - failed to write.");
        }
        catch (Exception ex) {
            throw new ModbusIOException("I/O exception - failed to write.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModbusRequest readRequest() throws ModbusIOException {
        try {
            ModbusRequest req = null;
            this.m_ByteIn.reset();
            BytesInputStream bytesInputStream = this.m_ByteIn;
            synchronized (bytesInputStream) {
                byte[] buffer = this.m_ByteIn.getBuffer();
                if (!this.headless) {
                    if (this.m_Input.read(buffer, 0, 6) == -1) {
                        throw new EOFException("Premature end of stream (Header truncated).");
                    }
                    int transaction = ModbusUtil.registerToShort(buffer, 0) & 0xFFFF;
                    short protocol = ModbusUtil.registerToShort(buffer, 2);
                    short count = ModbusUtil.registerToShort(buffer, 4);
                    if (this.m_Input.read(buffer, 6, count) == -1) {
                        throw new ModbusIOException("Premature end of stream (Message truncated).");
                    }
                    System.err.println("Read: " + ModbusUtil.toHex(buffer, 0, count + 6));
                    this.m_ByteIn.reset(buffer, 6 + count);
                    this.m_ByteIn.skip(6);
                    byte unit = this.m_ByteIn.readByte();
                    int functionCode = this.m_ByteIn.readUnsignedByte();
                    this.m_ByteIn.reset();
                    req = ModbusRequest.createModbusRequest(functionCode);
                    req.setUnitID(unit);
                    req.setHeadless(false);
                    req.setTransactionID(transaction);
                    req.setProtocolID(protocol);
                    req.setDataLength(count);
                    req.readFrom(this.m_ByteIn);
                } else {
                    byte unit = this.m_Input.readByte();
                    byte function = this.m_Input.readByte();
                    req = ModbusRequest.createModbusRequest(function);
                    req.setUnitID(unit);
                    req.setHeadless(true);
                    req.readData(this.m_Input);
                    this.m_Input.readShort();
                    System.err.println("Read: " + req.getHexMessage());
                }
            }
            return req;
        }
        catch (EOFException eoex) {
            throw new ModbusIOException("End of File", true);
        }
        catch (SocketTimeoutException x) {
            throw new ModbusIOException("Timeout reading request");
        }
        catch (SocketException sockex) {
            throw new ModbusIOException("Socket Exception", true);
        }
        catch (Exception ex) {
            throw new ModbusIOException("I/O exception - failed to read.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModbusResponse readResponse() throws ModbusIOException {
        try {
            ModbusResponse response = null;
            BytesInputStream bytesInputStream = this.m_ByteIn;
            synchronized (bytesInputStream) {
                byte[] buffer = this.m_ByteIn.getBuffer();
                System.err.println("Read: " + ModbusUtil.toHex(buffer, 0, this.m_ByteIn.count));
                if (!this.headless) {
                    if (this.m_Input.read(buffer, 0, 6) == -1) {
                        throw new ModbusIOException("Premature end of stream (Header truncated).");
                    }
                    int transaction = ModbusUtil.registerToShort(buffer, 0) & 0xFFFF;
                    short protocol = ModbusUtil.registerToShort(buffer, 2);
                    short count = ModbusUtil.registerToShort(buffer, 4);
                    if (this.m_Input.read(buffer, 6, count) == -1) {
                        throw new ModbusIOException("Premature end of stream (Message truncated).");
                    }
                    this.m_ByteIn.reset(buffer, 6 + count);
                    this.m_ByteIn.reset();
                    this.m_ByteIn.skip(7);
                    int function = this.m_ByteIn.readUnsignedByte();
                    response = ModbusResponse.createModbusResponse(function);
                    this.m_ByteIn.reset();
                    response.readFrom(this.m_ByteIn);
                    response.setTransactionID(transaction);
                    response.setProtocolID(protocol);
                } else {
                    byte unit = this.m_Input.readByte();
                    byte function = this.m_Input.readByte();
                    response = ModbusResponse.createModbusResponse(function);
                    response.setUnitID(unit);
                    response.setHeadless();
                    response.readData(this.m_Input);
                    this.m_Input.readShort();
                }
            }
            return response;
        }
        catch (SocketTimeoutException ex) {
            throw new ModbusIOException("Timeout reading response");
        }
        catch (Exception ex) {
            throw new ModbusIOException("I/O exception - failed to read.");
        }
    }

    private void prepareStreams(Socket socket) throws IOException {
        try {
            if (this.m_Input != null) {
                this.m_Input.close();
            }
            if (this.m_Output != null) {
                this.m_Output.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.m_Input = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
        this.m_Output = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream()));
        this.m_ByteIn = new BytesInputStream(262);
        this.m_ByteOut = new BytesOutputStream(262);
    }

    public ModbusTCPTransport(Socket socket) {
        try {
            this.setSocket(socket);
            socket.setSoTimeout(this.m_Timeout);
        }
        catch (IOException ex) {
            System.out.println("ModbusTCPTransport::Socket invalid.");
            throw new IllegalStateException("Socket invalid.");
        }
    }
}

