/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.io;

import com.ghgande.j2mod.modbus.ModbusException;
import com.ghgande.j2mod.modbus.ModbusIOException;
import com.ghgande.j2mod.modbus.ModbusSlaveException;
import com.ghgande.j2mod.modbus.io.ModbusTransaction;
import com.ghgande.j2mod.modbus.io.ModbusTransport;
import com.ghgande.j2mod.modbus.msg.ExceptionResponse;
import com.ghgande.j2mod.modbus.msg.ModbusRequest;
import com.ghgande.j2mod.modbus.msg.ModbusResponse;
import com.ghgande.j2mod.modbus.net.UDPMasterConnection;
import com.ghgande.j2mod.modbus.net.UDPTerminal;

public class ModbusUDPTransaction
implements ModbusTransaction {
    private static int c_TransactionID = 0;
    private UDPTerminal m_Terminal;
    private ModbusTransport m_IO;
    private ModbusRequest m_Request;
    private ModbusResponse m_Response;
    private boolean m_ValidityCheck = true;
    private int m_Retries = 3;
    private int m_RetryCounter = 0;

    public ModbusUDPTransaction() {
    }

    public ModbusUDPTransaction(ModbusRequest request) {
        this.setRequest(request);
    }

    public ModbusUDPTransaction(UDPTerminal terminal) {
        this.setTerminal(terminal);
    }

    public ModbusUDPTransaction(UDPMasterConnection con) {
        this.setTerminal(con.getTerminal());
    }

    public void setTerminal(UDPTerminal terminal) {
        this.m_Terminal = terminal;
        if (terminal.isActive()) {
            this.m_IO = terminal.getModbusTransport();
        }
    }

    @Override
    public void setRequest(ModbusRequest req) {
        this.m_Request = req;
    }

    @Override
    public ModbusRequest getRequest() {
        return this.m_Request;
    }

    @Override
    public ModbusResponse getResponse() {
        return this.m_Response;
    }

    @Override
    public int getTransactionID() {
        return c_TransactionID & 0xFFFF;
    }

    @Override
    public void setCheckingValidity(boolean b) {
        this.m_ValidityCheck = b;
    }

    @Override
    public boolean isCheckingValidity() {
        return this.m_ValidityCheck;
    }

    @Override
    public int getRetries() {
        return this.m_Retries;
    }

    @Override
    public void setRetries(int num) {
        this.m_Retries = num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws ModbusIOException, ModbusSlaveException, ModbusException {
        this.assertExecutable();
        if (!this.m_Terminal.isActive()) {
            try {
                this.m_Terminal.activate();
                this.m_IO = this.m_Terminal.getModbusTransport();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new ModbusIOException("Activation failed.");
            }
        }
        this.m_RetryCounter = 0;
        while (this.m_RetryCounter <= this.m_Retries) {
            try {
                ModbusTransport ex = this.m_IO;
                synchronized (ex) {
                    this.m_IO.writeMessage(this.m_Request);
                    this.m_Response = this.m_IO.readResponse();
                    break;
                }
            }
            catch (ModbusIOException ex) {
                ++this.m_RetryCounter;
            }
        }
        if (this.m_Response instanceof ExceptionResponse) {
            throw new ModbusSlaveException(((ExceptionResponse)this.m_Response).getExceptionCode());
        }
        if (this.isCheckingValidity()) {
            this.checkValidity();
        }
        this.incrementTransactionID();
    }

    private void assertExecutable() throws ModbusException {
        if (this.m_Request == null || this.m_Terminal == null) {
            throw new ModbusException("Assertion failed, transaction not executable");
        }
    }

    private void checkValidity() throws ModbusException {
    }

    private void incrementTransactionID() {
        if (this.isCheckingValidity()) {
            c_TransactionID = c_TransactionID >= Short.MAX_VALUE ? 1 : ++c_TransactionID;
        }
        this.m_Request.setTransactionID(this.getTransactionID());
    }
}

