/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.io;

import com.ghgande.j2mod.modbus.ModbusIOException;
import com.ghgande.j2mod.modbus.io.BytesInputStream;
import com.ghgande.j2mod.modbus.io.BytesOutputStream;
import com.ghgande.j2mod.modbus.io.ModbusTransaction;
import com.ghgande.j2mod.modbus.io.ModbusTransport;
import com.ghgande.j2mod.modbus.io.ModbusUDPTransaction;
import com.ghgande.j2mod.modbus.msg.ModbusMessage;
import com.ghgande.j2mod.modbus.msg.ModbusRequest;
import com.ghgande.j2mod.modbus.msg.ModbusResponse;
import com.ghgande.j2mod.modbus.net.UDPTerminal;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Arrays;

public class ModbusUDPTransport
implements ModbusTransport {
    private UDPTerminal m_Terminal;
    private BytesOutputStream m_ByteOut;
    private BytesInputStream m_ByteIn;

    @Override
    public void close() throws IOException {
    }

    public boolean getDebug() {
        return "true".equals(System.getProperty("com.ghgande.j2mod.modbus.debug"));
    }

    @Override
    public ModbusTransaction createTransaction() {
        ModbusUDPTransaction trans = new ModbusUDPTransaction();
        trans.setTerminal(this.m_Terminal);
        return trans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeMessage(ModbusMessage msg) throws ModbusIOException {
        try {
            BytesOutputStream bytesOutputStream = this.m_ByteOut;
            synchronized (bytesOutputStream) {
                int len = msg.getOutputLength();
                this.m_ByteOut.reset();
                msg.writeTo(this.m_ByteOut);
                byte[] data = this.m_ByteOut.getBuffer();
                data = Arrays.copyOf(data, len);
                this.m_Terminal.sendMessage(data);
            }
        }
        catch (Exception ex) {
            throw new ModbusIOException("I/O exception - failed to write.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModbusRequest readRequest() throws ModbusIOException {
        try {
            ModbusRequest req = null;
            BytesInputStream bytesInputStream = this.m_ByteIn;
            synchronized (bytesInputStream) {
                this.m_ByteIn.reset(this.m_Terminal.receiveMessage());
                this.m_ByteIn.skip(7);
                int functionCode = this.m_ByteIn.readUnsignedByte();
                this.m_ByteIn.reset();
                req = ModbusRequest.createModbusRequest(functionCode);
                req.readFrom(this.m_ByteIn);
            }
            return req;
        }
        catch (Exception ex) {
            throw new ModbusIOException("I/O exception - failed to read.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModbusResponse readResponse() throws ModbusIOException {
        try {
            ModbusResponse res = null;
            BytesInputStream bytesInputStream = this.m_ByteIn;
            synchronized (bytesInputStream) {
                this.m_ByteIn.reset(this.m_Terminal.receiveMessage());
                this.m_ByteIn.skip(7);
                int functionCode = this.m_ByteIn.readUnsignedByte();
                this.m_ByteIn.reset();
                res = ModbusResponse.createModbusResponse(functionCode);
                res.readFrom(this.m_ByteIn);
            }
            return res;
        }
        catch (InterruptedIOException ioex) {
            throw new ModbusIOException("Socket timed out.");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ModbusIOException("I/O exception - failed to read.");
        }
    }

    public ModbusUDPTransport(UDPTerminal terminal) {
        this.m_Terminal = terminal;
        this.m_ByteOut = new BytesOutputStream(256);
        this.m_ByteIn = new BytesInputStream(256);
    }
}

