/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.msg;

import com.ghgande.j2mod.modbus.ModbusCoupler;
import com.ghgande.j2mod.modbus.msg.MaskWriteRegisterResponse;
import com.ghgande.j2mod.modbus.msg.ModbusRequest;
import com.ghgande.j2mod.modbus.msg.ModbusResponse;
import com.ghgande.j2mod.modbus.procimg.IllegalAddressException;
import com.ghgande.j2mod.modbus.procimg.ProcessImage;
import com.ghgande.j2mod.modbus.procimg.Register;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class MaskWriteRegisterRequest
extends ModbusRequest {
    private int m_Reference;
    private int m_AndMask;
    private int m_OrMask;

    public int getReference() {
        return this.m_Reference;
    }

    public void setReference(int ref) {
        this.m_Reference = ref;
    }

    public int getAndMask() {
        return this.m_AndMask;
    }

    public void setAndMask(int mask) {
        this.m_AndMask = mask;
    }

    public int getOrMask() {
        return this.m_OrMask;
    }

    public void setOrMask(int mask) {
        this.m_OrMask = mask;
    }

    @Override
    public ModbusResponse getResponse() {
        MaskWriteRegisterResponse response = null;
        response = new MaskWriteRegisterResponse();
        response.setHeadless(this.isHeadless());
        if (!this.isHeadless()) {
            response.setTransactionID(this.getTransactionID());
            response.setProtocolID(this.getProtocolID());
        }
        response.setUnitID(this.getUnitID());
        response.setFunctionCode(this.getFunctionCode());
        return response;
    }

    @Override
    public ModbusResponse createResponse() {
        MaskWriteRegisterResponse response = null;
        ProcessImage procimg = ModbusCoupler.getReference().getProcessImage();
        try {
            Register register = procimg.getRegister(this.m_Reference);
            int value = register.getValue();
            value = value & this.m_AndMask | this.m_OrMask & ~this.m_AndMask;
            register.setValue(value);
        }
        catch (IllegalAddressException iaex) {
            return this.createExceptionResponse(2);
        }
        response = (MaskWriteRegisterResponse)this.getResponse();
        response.setReference(this.m_Reference);
        response.setAndMask(this.m_AndMask);
        response.setOrMask(this.m_OrMask);
        return response;
    }

    @Override
    public void writeData(DataOutput dout) throws IOException {
        dout.write(this.getMessage());
    }

    @Override
    public void readData(DataInput din) throws IOException {
        this.m_Reference = din.readShort();
        this.m_AndMask = din.readShort();
        this.m_OrMask = din.readShort();
    }

    @Override
    public byte[] getMessage() {
        byte[] results = new byte[]{(byte)(this.m_Reference >> 8), (byte)(this.m_Reference & 0xFF), (byte)(this.m_AndMask >> 8), (byte)(this.m_AndMask & 0xFF), (byte)(this.m_OrMask >> 8), (byte)(this.m_OrMask & 0xFF)};
        return results;
    }

    public MaskWriteRegisterRequest(int ref, int andMask, int orMask) {
        this.setFunctionCode(22);
        this.setReference(ref);
        this.setAndMask(andMask);
        this.setOrMask(orMask);
        this.setDataLength(6);
    }

    public MaskWriteRegisterRequest() {
        this.setFunctionCode(22);
        this.setDataLength(6);
    }
}

