/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.msg;

import com.ghgande.j2mod.modbus.msg.ModbusMessage;
import com.ghgande.j2mod.modbus.util.ModbusUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public abstract class ModbusMessageImpl
implements ModbusMessage {
    private int m_TransactionID = 0;
    private int m_ProtocolID = 0;
    private int m_DataLength;
    private int m_UnitID = 0;
    private int m_FunctionCode;
    private boolean m_Headless = false;

    @Override
    public boolean isHeadless() {
        return this.m_Headless;
    }

    @Override
    public void setHeadless() {
        this.m_Headless = true;
    }

    public void setHeadless(boolean b) {
        this.m_Headless = b;
    }

    @Override
    public int getTransactionID() {
        return this.m_TransactionID & 0xFFFF;
    }

    public void setTransactionID(int tid) {
        this.m_TransactionID = tid & 0xFFFF;
    }

    @Override
    public int getProtocolID() {
        return this.m_ProtocolID;
    }

    public void setProtocolID(int pid) {
        this.m_ProtocolID = pid;
    }

    @Override
    public int getDataLength() {
        return this.m_DataLength;
    }

    public void setDataLength(int length) {
        if (length < 0 || length + 2 > 255) {
            throw new IllegalArgumentException("Invalid length: " + length);
        }
        this.m_DataLength = length + 2;
    }

    @Override
    public int getUnitID() {
        return this.m_UnitID;
    }

    public void setUnitID(int num) {
        this.m_UnitID = num;
    }

    @Override
    public int getFunctionCode() {
        return this.m_FunctionCode;
    }

    protected void setFunctionCode(int code) {
        this.m_FunctionCode = code;
    }

    @Override
    public void writeTo(DataOutput dout) throws IOException {
        if (!this.isHeadless()) {
            dout.writeShort(this.getTransactionID());
            dout.writeShort(this.getProtocolID());
            dout.writeShort(this.getDataLength());
        }
        dout.writeByte(this.getUnitID());
        dout.writeByte(this.getFunctionCode());
        this.writeData(dout);
    }

    public abstract void writeData(DataOutput var1) throws IOException;

    @Override
    public void readFrom(DataInput din) throws IOException {
        if (!this.isHeadless()) {
            this.setTransactionID(din.readUnsignedShort());
            this.setProtocolID(din.readUnsignedShort());
            this.m_DataLength = din.readUnsignedShort();
        }
        this.setUnitID(din.readUnsignedByte());
        this.setFunctionCode(din.readUnsignedByte());
        this.readData(din);
    }

    public abstract void readData(DataInput var1) throws IOException;

    @Override
    public int getOutputLength() {
        int l = 2 + this.getDataLength();
        if (!this.isHeadless()) {
            l += 4;
        }
        return l;
    }

    @Override
    public String getHexMessage() {
        return ModbusUtil.toHex(this);
    }
}

