/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.msg;

import com.ghgande.j2mod.modbus.ModbusCoupler;
import com.ghgande.j2mod.modbus.msg.IllegalAddressExceptionResponse;
import com.ghgande.j2mod.modbus.msg.ModbusRequest;
import com.ghgande.j2mod.modbus.msg.ModbusResponse;
import com.ghgande.j2mod.modbus.msg.ReadCoilsResponse;
import com.ghgande.j2mod.modbus.procimg.DigitalOut;
import com.ghgande.j2mod.modbus.procimg.IllegalAddressException;
import com.ghgande.j2mod.modbus.procimg.ProcessImage;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class ReadCoilsRequest
extends ModbusRequest {
    private int m_Reference;
    private int m_BitCount;

    public ReadCoilsRequest() {
        this.setFunctionCode(1);
        this.setDataLength(4);
    }

    public ReadCoilsRequest(int ref, int count) {
        this.setFunctionCode(1);
        this.setDataLength(4);
        this.setReference(ref);
        this.setBitCount(count);
    }

    @Override
    public ReadCoilsResponse getResponse() {
        ReadCoilsResponse response = null;
        response = new ReadCoilsResponse(this.m_BitCount);
        if (!this.isHeadless()) {
            response.setTransactionID(this.getTransactionID());
            response.setProtocolID(this.getProtocolID());
        } else {
            response.setHeadless();
        }
        response.setUnitID(this.getUnitID());
        return response;
    }

    @Override
    public ModbusResponse createResponse() {
        ModbusResponse response = null;
        DigitalOut[] douts = null;
        ProcessImage procimg = ModbusCoupler.getReference().getProcessImage();
        try {
            douts = procimg.getDigitalOutRange(this.getReference(), this.getBitCount());
        }
        catch (IllegalAddressException e) {
            response = new IllegalAddressExceptionResponse();
            response.setUnitID(this.getUnitID());
            response.setFunctionCode(this.getFunctionCode());
            return response;
        }
        response = this.getResponse();
        int i = 0;
        while (i < douts.length) {
            ((ReadCoilsResponse)response).setCoilStatus(i, douts[i].isSet());
            ++i;
        }
        return response;
    }

    public void setReference(int ref) {
        this.m_Reference = ref;
    }

    public int getReference() {
        return this.m_Reference;
    }

    public void setBitCount(int count) {
        if (count > 2000) {
            throw new IllegalArgumentException("Maximum bitcount exceeded.");
        }
        this.m_BitCount = count;
    }

    public int getBitCount() {
        return this.m_BitCount;
    }

    @Override
    public void writeData(DataOutput dout) throws IOException {
        dout.write(this.getMessage());
    }

    @Override
    public void readData(DataInput din) throws IOException {
        this.m_Reference = din.readUnsignedShort();
        this.m_BitCount = din.readUnsignedShort();
    }

    @Override
    public byte[] getMessage() {
        byte[] result = new byte[]{(byte)(this.m_Reference >> 8 & 0xFF), (byte)(this.m_Reference & 0xFF), (byte)(this.m_BitCount >> 8 & 0xFF), (byte)(this.m_BitCount & 0xFF)};
        return result;
    }
}

