/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.msg;

import com.ghgande.j2mod.modbus.msg.ModbusResponse;
import com.ghgande.j2mod.modbus.util.BitVector;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class ReadCoilsResponse
extends ModbusResponse {
    private BitVector coils;

    public int getBitCount() {
        if (this.coils == null) {
            return 0;
        }
        return this.coils.size();
    }

    public BitVector getCoils() {
        return this.coils;
    }

    public boolean getCoilStatus(int index) throws IndexOutOfBoundsException {
        if (index < 0) {
            throw new IllegalArgumentException(String.valueOf(index) + " < 0");
        }
        if (index > this.coils.size()) {
            throw new IndexOutOfBoundsException(String.valueOf(index) + " > " + this.coils.size());
        }
        return this.coils.getBit(index);
    }

    public void setCoilStatus(int index, boolean b) {
        if (index < 0) {
            throw new IllegalArgumentException(String.valueOf(index) + " < 0");
        }
        if (index > this.coils.size()) {
            throw new IndexOutOfBoundsException(String.valueOf(index) + " > " + this.coils.size());
        }
        this.coils.setBit(index, b);
    }

    @Override
    public void writeData(DataOutput output) throws IOException {
        byte[] result = this.getMessage();
        output.write(result);
    }

    @Override
    public void readData(DataInput input) throws IOException {
        int count = input.readUnsignedByte();
        byte[] data = new byte[count];
        input.readFully(data, 0, count);
        this.coils = BitVector.createBitVector(data);
        this.setDataLength(count + 1);
    }

    @Override
    public byte[] getMessage() {
        int len = 1 + this.coils.byteSize();
        byte[] result = new byte[len];
        result[0] = (byte)this.coils.byteSize();
        System.arraycopy(this.coils.getBytes(), 0, result, 1, this.coils.byteSize());
        return result;
    }

    public ReadCoilsResponse() {
        this.setFunctionCode(1);
        this.setDataLength(1);
        this.coils = null;
    }

    public ReadCoilsResponse(int count) {
        this.setFunctionCode(1);
        this.coils = new BitVector(count);
        this.setDataLength(this.coils.byteSize() + 1);
    }
}

