/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.msg;

import com.ghgande.j2mod.modbus.msg.ModbusResponse;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class ReadCommEventLogResponse
extends ModbusResponse {
    private int m_ByteCount;
    private int m_Status;
    private int m_EventCount;
    private int m_MessageCount;
    private byte[] m_Events;

    public int getStatus() {
        return this.m_Status;
    }

    public void setStatus(int status) {
        this.m_Status = status;
    }

    public int getEventCount() {
        return this.m_EventCount;
    }

    public void setEventCount(int count) {
        this.m_EventCount = count;
    }

    public int getMessageCount() {
        return this.m_MessageCount;
    }

    public void setMessageCount(int count) {
        this.m_MessageCount = count;
    }

    public int getEvent(int index) {
        if (this.m_Events == null || index < 0 || index >= this.m_Events.length) {
            throw new IndexOutOfBoundsException("index = " + index + ", limit = " + this.m_Events.length);
        }
        return this.m_Events[index] & 0xFF;
    }

    public byte[] getEvents() {
        if (this.m_Events == null) {
            return null;
        }
        byte[] result = new byte[this.m_Events.length];
        System.arraycopy(this.m_Events, 0, result, 0, this.m_Events.length);
        return result;
    }

    public void setEvent(int index, int event) {
        if (this.m_Events == null || index < 0 || index >= this.m_Events.length) {
            throw new IndexOutOfBoundsException("index = " + index + ", limit = " + this.m_Events.length);
        }
        this.m_Events[index] = (byte)event;
    }

    public void setEvents(byte[] events) {
        if (events.length > 64) {
            throw new IllegalArgumentException("events list too big (> 64 bytes)");
        }
        this.m_Events = new byte[events.length];
        if (this.m_Events.length > 0) {
            System.arraycopy(events, 0, this.m_Events, 0, events.length);
        }
    }

    public void setEvents(int count) {
        if (count < 0 || count > 64) {
            throw new IllegalArgumentException("invalid event list size (0 <= count <= 64)");
        }
        this.m_Events = new byte[count];
    }

    @Override
    public void writeData(DataOutput dout) throws IOException {
        dout.write(this.getMessage());
    }

    @Override
    public void readData(DataInput din) throws IOException {
        this.m_ByteCount = din.readByte();
        this.m_Status = din.readShort();
        this.m_EventCount = din.readShort();
        this.m_MessageCount = din.readShort();
        this.m_Events = new byte[this.m_ByteCount - 6];
        if (this.m_Events.length > 0) {
            din.readFully(this.m_Events, 0, this.m_Events.length);
        }
    }

    @Override
    public byte[] getMessage() {
        byte[] result = new byte[this.m_Events.length + 7];
        this.m_ByteCount = this.m_Events.length + 6;
        result[0] = (byte)this.m_ByteCount;
        result[1] = (byte)(this.m_Status >> 8);
        result[2] = (byte)(this.m_Status & 0xFF);
        result[3] = (byte)(this.m_EventCount >> 8);
        result[4] = (byte)(this.m_EventCount & 0xFF);
        result[5] = (byte)(this.m_MessageCount >> 8);
        result[6] = (byte)(this.m_MessageCount & 0xFF);
        int i = 0;
        while (i < this.m_Events.length) {
            result[7 + i] = this.m_Events[i];
            ++i;
        }
        return result;
    }

    public ReadCommEventLogResponse() {
        this.setFunctionCode(12);
        this.setDataLength(7);
    }
}

