/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.msg;

import com.ghgande.j2mod.modbus.ModbusCoupler;
import com.ghgande.j2mod.modbus.msg.ModbusRequest;
import com.ghgande.j2mod.modbus.msg.ModbusResponse;
import com.ghgande.j2mod.modbus.msg.ReadFIFOQueueResponse;
import com.ghgande.j2mod.modbus.procimg.IllegalAddressException;
import com.ghgande.j2mod.modbus.procimg.InputRegister;
import com.ghgande.j2mod.modbus.procimg.ProcessImage;
import com.ghgande.j2mod.modbus.procimg.Register;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class ReadFIFOQueueRequest
extends ModbusRequest {
    private int m_Reference;

    public int getReference() {
        return this.m_Reference;
    }

    public void setReference(int ref) {
        this.m_Reference = ref;
    }

    @Override
    public ModbusResponse getResponse() {
        ReadFIFOQueueResponse response = null;
        response = new ReadFIFOQueueResponse();
        response.setHeadless(this.isHeadless());
        if (!this.isHeadless()) {
            response.setTransactionID(this.getTransactionID());
            response.setProtocolID(this.getProtocolID());
        }
        response.setUnitID(this.getUnitID());
        response.setFunctionCode(this.getFunctionCode());
        return response;
    }

    @Override
    public ModbusResponse createResponse() {
        ReadFIFOQueueResponse response = null;
        InputRegister[] registers = null;
        ProcessImage procimg = ModbusCoupler.getReference().getProcessImage();
        try {
            Register queue = procimg.getRegister(this.m_Reference);
            int count = queue.getValue();
            if (count < 0 || count > 31) {
                return this.createExceptionResponse(3);
            }
            registers = procimg.getRegisterRange(this.m_Reference + 1, count);
        }
        catch (IllegalAddressException e) {
            return this.createExceptionResponse(2);
        }
        response = (ReadFIFOQueueResponse)this.getResponse();
        response.setRegisters(registers);
        return response;
    }

    @Override
    public void writeData(DataOutput dout) throws IOException {
        dout.write(this.getMessage());
    }

    @Override
    public void readData(DataInput din) throws IOException {
        this.m_Reference = din.readShort();
    }

    @Override
    public byte[] getMessage() {
        byte[] results = new byte[]{(byte)(this.m_Reference >> 8), (byte)(this.m_Reference & 0xFF)};
        return results;
    }

    public ReadFIFOQueueRequest() {
        this.setFunctionCode(24);
        this.setDataLength(2);
    }
}

