/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.msg;

import com.ghgande.j2mod.modbus.msg.ModbusResponse;
import com.ghgande.j2mod.modbus.procimg.InputRegister;
import com.ghgande.j2mod.modbus.procimg.SimpleInputRegister;
import com.ghgande.j2mod.modbus.procimg.SimpleRegister;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class ReadFIFOQueueResponse
extends ModbusResponse {
    private int m_Count;
    private InputRegister[] m_Registers;

    public int getWordCount() {
        return this.m_Count;
    }

    public synchronized void setWordCount(int ref) {
        if (ref < 0 || ref > 31) {
            throw new IllegalArgumentException();
        }
        int oldCount = this.m_Count;
        InputRegister[] newRegisters = new InputRegister[ref];
        this.m_Count = ref;
        int i = 0;
        while (i < ref) {
            newRegisters[i] = i < oldCount ? this.m_Registers[i] : new SimpleRegister(0);
            ++i;
        }
    }

    public int[] getRegisters() {
        int[] values = new int[this.m_Count];
        int i = 0;
        while (i < this.m_Count) {
            values[i] = this.getRegister(i);
            ++i;
        }
        return values;
    }

    public int getRegister(int index) {
        return this.m_Registers[index].getValue();
    }

    public synchronized void setRegisters(InputRegister[] regs) {
        this.m_Registers = regs;
        if (regs == null) {
            this.m_Count = 0;
            return;
        }
        if (regs.length > 31) {
            throw new IllegalArgumentException();
        }
        this.m_Count = regs.length;
    }

    @Override
    public void writeData(DataOutput dout) throws IOException {
        dout.write(this.getMessage());
    }

    @Override
    public void readData(DataInput din) throws IOException {
        short byteCount = din.readShort();
        this.m_Count = din.readShort();
        this.m_Registers = new InputRegister[this.m_Count];
        int i = 0;
        while (i < this.m_Count) {
            this.m_Registers[i] = new SimpleInputRegister(din.readShort());
            ++i;
        }
    }

    @Override
    public byte[] getMessage() {
        byte[] result = new byte[this.m_Count * 2 + 4];
        int len = this.m_Count * 2 + 2;
        result[0] = (byte)(len >> 8);
        result[1] = (byte)(len & 0xFF);
        result[2] = (byte)(this.m_Count >> 8);
        result[3] = (byte)(this.m_Count & 0xFF);
        int i = 0;
        while (i < this.m_Count) {
            byte[] value = this.m_Registers[i].toBytes();
            result[i * 2 + 4] = value[0];
            result[i * 2 + 5] = value[1];
            ++i;
        }
        return result;
    }

    public ReadFIFOQueueResponse() {
        this.setFunctionCode(24);
        this.m_Count = 0;
        this.m_Registers = new InputRegister[0];
        this.setDataLength(7);
    }
}

