/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.msg;

import com.ghgande.j2mod.modbus.ModbusCoupler;
import com.ghgande.j2mod.modbus.msg.ModbusRequest;
import com.ghgande.j2mod.modbus.msg.ModbusResponse;
import com.ghgande.j2mod.modbus.msg.ReadFileRecordResponse;
import com.ghgande.j2mod.modbus.procimg.File;
import com.ghgande.j2mod.modbus.procimg.IllegalAddressException;
import com.ghgande.j2mod.modbus.procimg.ProcessImage;
import com.ghgande.j2mod.modbus.procimg.Record;
import com.ghgande.j2mod.modbus.procimg.Register;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class ReadFileRecordRequest
extends ModbusRequest {
    private int m_ByteCount;
    private RecordRequest[] m_Records;

    public int getRequestSize() {
        if (this.m_Records == null) {
            return 1;
        }
        int size = 1;
        int i = 0;
        while (i < this.m_Records.length) {
            size += this.m_Records[i].getRequestSize();
            ++i;
        }
        return size;
    }

    public int getRequestCount() {
        if (this.m_Records == null) {
            return 0;
        }
        return this.m_Records.length;
    }

    public RecordRequest getRecord(int index) {
        return this.m_Records[index];
    }

    public void addRequest(RecordRequest request) {
        if (request.getRequestSize() + this.getRequestSize() > 248) {
            throw new IllegalArgumentException();
        }
        if (this.m_Records == null) {
            this.m_Records = new RecordRequest[1];
        } else {
            RecordRequest[] old = this.m_Records;
            this.m_Records = new RecordRequest[old.length + 1];
            System.arraycopy(old, 0, this.m_Records, 0, old.length);
        }
        this.m_Records[this.m_Records.length - 1] = request;
        this.setDataLength(this.getRequestSize());
    }

    @Override
    public ModbusResponse getResponse() {
        ReadFileRecordResponse response = null;
        response = new ReadFileRecordResponse();
        response.setHeadless(this.isHeadless());
        if (!this.isHeadless()) {
            response.setTransactionID(this.getTransactionID());
            response.setProtocolID(this.getProtocolID());
        }
        response.setUnitID(this.getUnitID());
        response.setFunctionCode(this.getFunctionCode());
        return response;
    }

    @Override
    public ModbusResponse createResponse() {
        ReadFileRecordResponse response = null;
        response = (ReadFileRecordResponse)this.getResponse();
        ProcessImage procimg = ModbusCoupler.getReference().getProcessImage();
        try {
            int i = 0;
            while (i < this.getRequestCount()) {
                RecordRequest recordRequest = this.getRecord(i);
                if (recordRequest.getFileNumber() < 0 || recordRequest.getFileNumber() >= procimg.getFileCount()) {
                    return this.createExceptionResponse(2);
                }
                File file = procimg.getFileByNumber(recordRequest.getFileNumber());
                if (recordRequest.getRecordNumber() < 0 || recordRequest.getRecordNumber() >= file.getRecordCount()) {
                    return this.createExceptionResponse(2);
                }
                Record record = file.getRecord(recordRequest.getRecordNumber());
                int registers = recordRequest.getWordCount();
                if (record == null && registers != 0) {
                    return this.createExceptionResponse(2);
                }
                short[] data = new short[registers];
                int j = 0;
                while (j < registers) {
                    Register register = record.getRegister(j);
                    if (register == null) {
                        return this.createExceptionResponse(2);
                    }
                    data[j] = register.toShort();
                    ++j;
                }
                ReadFileRecordResponse readFileRecordResponse = response;
                readFileRecordResponse.getClass();
                ReadFileRecordResponse.RecordResponse recordResponse = new ReadFileRecordResponse.RecordResponse(readFileRecordResponse, data);
                response.addResponse(recordResponse);
                ++i;
            }
        }
        catch (IllegalAddressException e) {
            return this.createExceptionResponse(2);
        }
        return response;
    }

    @Override
    public void writeData(DataOutput dout) throws IOException {
        dout.write(this.getMessage());
    }

    @Override
    public void readData(DataInput din) throws IOException {
        this.m_ByteCount = din.readUnsignedByte();
        int recordCount = this.m_ByteCount / 7;
        this.m_Records = new RecordRequest[recordCount];
        int i = 0;
        while (i < recordCount) {
            if (din.readByte() != 6) {
                throw new IOException();
            }
            int file = din.readUnsignedShort();
            int record = din.readUnsignedShort();
            if (record < 0 || record >= 10000) {
                throw new IOException();
            }
            int count = din.readUnsignedShort();
            this.m_Records[i] = new RecordRequest(file, record, count);
            ++i;
        }
    }

    @Override
    public byte[] getMessage() {
        byte[] request = new byte[1 + 7 * this.m_Records.length];
        int offset = 0;
        request[offset++] = (byte)(request.length - 1);
        int i = 0;
        while (i < this.m_Records.length) {
            this.m_Records[i].getRequest(request, offset);
            offset += 7;
            ++i;
        }
        return request;
    }

    public ReadFileRecordRequest() {
        this.setFunctionCode(20);
        this.setDataLength(1);
    }

    public class RecordRequest {
        private int m_FileNumber;
        private int m_RecordNumber;
        private int m_WordCount;

        public int getFileNumber() {
            return this.m_FileNumber;
        }

        public int getRecordNumber() {
            return this.m_RecordNumber;
        }

        public int getWordCount() {
            return this.m_WordCount;
        }

        public int getRequestSize() {
            return 7 + this.m_WordCount * 2;
        }

        public void getRequest(byte[] request, int offset) {
            request[offset] = 6;
            request[offset + 1] = (byte)(this.m_FileNumber >> 8);
            request[offset + 2] = (byte)(this.m_FileNumber & 0xFF);
            request[offset + 3] = (byte)(this.m_RecordNumber >> 8);
            request[offset + 4] = (byte)(this.m_RecordNumber & 0xFF);
            request[offset + 5] = (byte)(this.m_WordCount >> 8);
            request[offset + 6] = (byte)(this.m_WordCount & 0xFF);
        }

        public byte[] getRequest() {
            byte[] request = new byte[7];
            this.getRequest(request, 0);
            return request;
        }

        public RecordRequest(int file, int record, int count) {
            this.m_FileNumber = file;
            this.m_RecordNumber = record;
            this.m_WordCount = count;
        }
    }
}

