/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.msg;

import com.ghgande.j2mod.modbus.msg.ModbusResponse;
import com.ghgande.j2mod.modbus.procimg.SimpleRegister;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class ReadFileRecordResponse
extends ModbusResponse {
    private int m_ByteCount;
    private RecordResponse[] m_Records = null;

    public int getByteCount() {
        if (this.m_Records == null) {
            return 1;
        }
        int size = 1;
        int i = 0;
        while (i < this.m_Records.length) {
            size += this.m_Records[i].getResponseSize();
            ++i;
        }
        return size;
    }

    public int getRecordCount() {
        if (this.m_Records == null) {
            return 0;
        }
        return this.m_Records.length;
    }

    public RecordResponse getRecord(int index) {
        return this.m_Records[index];
    }

    public void addResponse(RecordResponse response) {
        if (this.m_Records == null) {
            this.m_Records = new RecordResponse[1];
        } else {
            RecordResponse[] old = this.m_Records;
            this.m_Records = new RecordResponse[old.length + 1];
            System.arraycopy(old, 0, this.m_Records, 0, old.length);
        }
        this.m_Records[this.m_Records.length - 1] = response;
    }

    @Override
    public void writeData(DataOutput dout) throws IOException {
        dout.writeByte(this.getByteCount() - 1);
        if (this.m_Records == null) {
            return;
        }
        int i = 0;
        while (i < this.m_Records.length) {
            dout.write(this.m_Records[i].getResponse());
            ++i;
        }
    }

    @Override
    public void readData(DataInput din) throws IOException {
        int remainder = this.m_ByteCount = din.readUnsignedByte() & 0xFF;
        while (remainder > 0) {
            int length = din.readUnsignedByte();
            --remainder;
            byte function = din.readByte();
            if (function != 6 || length - 1 > --remainder) {
                throw new IOException("Invalid response format");
            }
            short[] data = new short[(length - 1) / 2];
            int i = 0;
            while (i < data.length) {
                data[i] = din.readShort();
                remainder -= 2;
                ++i;
            }
            RecordResponse response = new RecordResponse(data);
            this.addResponse(response);
        }
        this.setDataLength(this.m_ByteCount + 1);
    }

    @Override
    public byte[] getMessage() {
        byte[] result = null;
        result = new byte[this.getByteCount()];
        int offset = 0;
        result[offset++] = (byte)(result.length - 1);
        int i = 0;
        while (i < this.m_Records.length) {
            this.m_Records[i].getResponse(result, offset);
            offset += this.m_Records[i].getWordCount() * 2;
            ++i;
        }
        return result;
    }

    public ReadFileRecordResponse() {
        this.setFunctionCode(20);
    }

    public class RecordResponse {
        private int m_WordCount;
        private byte[] m_Data;

        public int getWordCount() {
            return this.m_WordCount;
        }

        public SimpleRegister getRegister(int register) {
            if (register < 0 || register >= this.m_WordCount) {
                throw new IndexOutOfBoundsException("0 <= " + register + " < " + this.m_WordCount);
            }
            byte b1 = this.m_Data[register * 2];
            byte b2 = this.m_Data[register * 2 + 1];
            SimpleRegister result = new SimpleRegister(b1, b2);
            return result;
        }

        public int getResponseSize() {
            return 2 + this.m_WordCount * 2;
        }

        public void getResponse(byte[] request, int offset) {
            request[offset] = (byte)(1 + this.m_WordCount * 2);
            request[offset + 1] = 6;
            System.arraycopy(this.m_Data, 0, request, offset + 2, this.m_Data.length);
        }

        public byte[] getResponse() {
            byte[] request = new byte[this.getResponseSize()];
            this.getResponse(request, 0);
            return request;
        }

        public RecordResponse(short[] data) {
            this.m_WordCount = data.length;
            this.m_Data = new byte[this.m_WordCount * 2];
            int offset = 0;
            int i = 0;
            while (i < this.m_WordCount) {
                this.m_Data[offset++] = (byte)(data[i] >> 8);
                this.m_Data[offset++] = (byte)(data[i] & 0xFF);
                ++i;
            }
        }
    }
}

