/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.msg;

import com.ghgande.j2mod.modbus.ModbusCoupler;
import com.ghgande.j2mod.modbus.msg.ModbusRequest;
import com.ghgande.j2mod.modbus.msg.ModbusResponse;
import com.ghgande.j2mod.modbus.msg.ReadInputDiscretesResponse;
import com.ghgande.j2mod.modbus.procimg.DigitalIn;
import com.ghgande.j2mod.modbus.procimg.IllegalAddressException;
import com.ghgande.j2mod.modbus.procimg.ProcessImage;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class ReadInputDiscretesRequest
extends ModbusRequest {
    private int m_Reference;
    private int m_BitCount;

    public ReadInputDiscretesRequest() {
        this.setFunctionCode(2);
        this.setDataLength(4);
    }

    public ReadInputDiscretesRequest(int ref, int count) {
        this.setFunctionCode(2);
        this.setDataLength(4);
        this.setReference(ref);
        this.setBitCount(count);
    }

    @Override
    public ReadInputDiscretesResponse getResponse() {
        ReadInputDiscretesResponse response = new ReadInputDiscretesResponse(this.getBitCount());
        response.setUnitID(this.getUnitID());
        response.setFunctionCode(this.getFunctionCode());
        response.setHeadless(this.isHeadless());
        if (!this.isHeadless()) {
            response.setTransactionID(this.getTransactionID());
            response.setProtocolID(this.getProtocolID());
        }
        return response;
    }

    @Override
    public ModbusResponse createResponse() {
        ReadInputDiscretesResponse response = null;
        DigitalIn[] dins = null;
        ProcessImage procimg = ModbusCoupler.getReference().getProcessImage();
        try {
            dins = procimg.getDigitalInRange(this.getReference(), this.getBitCount());
        }
        catch (IllegalAddressException e) {
            return this.createExceptionResponse(2);
        }
        response = this.getResponse();
        int i = 0;
        while (i < dins.length) {
            response.setDiscreteStatus(i, dins[i].isSet());
            ++i;
        }
        return response;
    }

    public void setReference(int ref) {
        if (ref < 0 || this.m_BitCount + ref >= 65536) {
            throw new IllegalArgumentException();
        }
        this.m_Reference = ref;
    }

    public int getReference() {
        return this.m_Reference;
    }

    public void setBitCount(int count) {
        if (count < 0 || count > 2000 || count + this.m_Reference >= 65536) {
            throw new IllegalArgumentException();
        }
        this.m_BitCount = count;
    }

    public int getBitCount() {
        return this.m_BitCount;
    }

    @Override
    public void writeData(DataOutput dout) throws IOException {
        dout.writeShort(this.m_Reference);
        dout.writeShort(this.m_BitCount);
    }

    @Override
    public void readData(DataInput din) throws IOException {
        this.m_Reference = din.readUnsignedShort();
        this.m_BitCount = din.readUnsignedShort();
    }

    @Override
    public byte[] getMessage() {
        byte[] result = new byte[]{(byte)(this.m_Reference >> 8 & 0xFF), (byte)(this.m_Reference & 0xFF), (byte)(this.m_BitCount >> 8 & 0xFF), (byte)(this.m_BitCount & 0xFF)};
        return result;
    }
}

