/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.msg;

import com.ghgande.j2mod.modbus.msg.ModbusResponse;
import com.ghgande.j2mod.modbus.procimg.InputRegister;
import com.ghgande.j2mod.modbus.procimg.SimpleInputRegister;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class ReadInputRegistersResponse
extends ModbusResponse {
    private int m_ByteCount;
    private InputRegister[] m_Registers;

    public ReadInputRegistersResponse() {
        this.setFunctionCode(4);
    }

    public ReadInputRegistersResponse(InputRegister[] registers) {
        this.setFunctionCode(4);
        this.setDataLength(registers.length * 2 + 1);
        this.m_ByteCount = registers.length * 2 + 1;
        this.m_Registers = registers;
    }

    public int getByteCount() {
        return this.m_ByteCount;
    }

    public int getWordCount() {
        return this.m_ByteCount / 2;
    }

    public void setWordCount(int count) {
        this.m_ByteCount = count * 2 + 1;
        InputRegister[] regs = new InputRegister[count];
        if (this.m_Registers != null) {
            int i = 0;
            while (i < this.m_Registers.length && i < count) {
                regs[i] = this.m_Registers[i];
                ++i;
            }
            if (this.m_Registers.length < count) {
                i = this.m_Registers.length;
                while (i < count) {
                    regs[i] = new SimpleInputRegister(0);
                    ++i;
                }
            }
        }
    }

    public InputRegister getRegister(int index) throws IndexOutOfBoundsException {
        if (index < 0) {
            throw new IndexOutOfBoundsException(String.valueOf(index) + " < 0");
        }
        if (index >= this.getWordCount()) {
            throw new IndexOutOfBoundsException(String.valueOf(index) + " >= " + this.getWordCount());
        }
        return this.m_Registers[index];
    }

    public int getRegisterValue(int index) throws IndexOutOfBoundsException {
        return this.getRegister(index).toUnsignedShort();
    }

    public InputRegister[] getRegisters() {
        return this.m_Registers;
    }

    public void setRegisters(InputRegister[] registers) {
        this.setDataLength(registers.length * 2 + 1);
        this.m_ByteCount = registers.length * 2 + 1;
        this.m_Registers = registers;
    }

    @Override
    public void writeData(DataOutput dout) throws IOException {
        dout.writeByte(this.m_ByteCount);
        int k = 0;
        while (k < this.getWordCount()) {
            dout.write(this.m_Registers[k].toBytes());
            ++k;
        }
    }

    @Override
    public void readData(DataInput din) throws IOException {
        this.m_ByteCount = din.readUnsignedByte();
        InputRegister[] registers = new InputRegister[this.getWordCount()];
        int k = 0;
        while (k < this.getWordCount()) {
            registers[k] = new SimpleInputRegister(din.readByte(), din.readByte());
            ++k;
        }
        this.m_Registers = registers;
        this.setDataLength(this.m_ByteCount + 1);
    }

    @Override
    public byte[] getMessage() {
        byte[] result = new byte[this.m_Registers.length * 2 + 1];
        result[0] = (byte)(this.m_Registers.length * 2);
        int i = 0;
        while (i < this.m_Registers.length) {
            byte[] value = this.m_Registers[i].toBytes();
            result[1 + i * 2] = value[0];
            result[2 + i * 2] = value[1];
            ++i;
        }
        return result;
    }
}

