/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.msg;

import com.ghgande.j2mod.modbus.msg.IllegalFunctionExceptionResponse;
import com.ghgande.j2mod.modbus.msg.ModbusRequest;
import com.ghgande.j2mod.modbus.msg.ModbusResponse;
import com.ghgande.j2mod.modbus.msg.ReadMEIResponse;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;

public final class ReadMEIRequest
extends ModbusRequest {
    private int m_SubCode;
    private int m_FieldLevel;
    private int m_FieldId;

    public ReadMEIRequest() {
        this.setFunctionCode(43);
        this.m_SubCode = 14;
        this.setDataLength(3);
    }

    public ReadMEIRequest(int level, int id) {
        this.setFunctionCode(43);
        this.m_SubCode = 14;
        this.setDataLength(3);
        this.setLevel(level);
        this.setFieldId(id);
    }

    @Override
    public ModbusResponse getResponse() {
        ReadMEIResponse response = null;
        if (this.getSubCode() != 14) {
            IllegalFunctionExceptionResponse error = new IllegalFunctionExceptionResponse();
            error.setUnitID(this.getUnitID());
            error.setFunctionCode(this.getFunctionCode());
            return error;
        }
        response = new ReadMEIResponse();
        if (!this.isHeadless()) {
            response.setTransactionID(this.getTransactionID());
            response.setProtocolID(this.getProtocolID());
        } else {
            response.setHeadless();
        }
        response.setUnitID(this.getUnitID());
        response.setFunctionCode(43);
        return response;
    }

    @Override
    public ModbusResponse createResponse() {
        return this.createExceptionResponse(1);
    }

    public int getSubCode() {
        return this.m_SubCode;
    }

    public void setLevel(int level) {
        this.m_FieldLevel = level;
    }

    public int getLevel() {
        return this.m_FieldLevel;
    }

    public void setFieldId(int id) {
        this.m_FieldId = id;
    }

    public int getFieldId() {
        return this.m_FieldId;
    }

    @Override
    public void writeData(DataOutput dout) throws IOException {
        byte[] results = new byte[]{(byte)this.m_SubCode, (byte)this.m_FieldLevel, (byte)this.m_FieldId};
        dout.write(results);
    }

    @Override
    public void readData(DataInput din) throws IOException {
        this.m_SubCode = din.readUnsignedByte();
        if (this.m_SubCode != 14) {
            try {
                while (din.readByte() >= 0) {
                }
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
            return;
        }
        this.m_FieldLevel = din.readUnsignedByte();
        this.m_FieldId = din.readUnsignedByte();
    }

    @Override
    public byte[] getMessage() {
        byte[] results = new byte[]{(byte)this.m_SubCode, (byte)this.m_FieldLevel, (byte)this.m_FieldId};
        return results;
    }
}

