/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.msg;

import com.ghgande.j2mod.modbus.msg.ModbusResponse;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class ReadMEIResponse
extends ModbusResponse {
    private int m_FieldLevel = 0;
    private int m_Conformity = 1;
    private int m_FieldCount = 0;
    private String[] m_Fields = new String[64];
    private int[] m_FieldIds = new int[64];
    private boolean m_MoreFollows = false;
    private int m_NextFieldId;

    public ReadMEIResponse() {
        this.setFunctionCode(43);
    }

    public int getFieldCount() {
        if (this.m_Fields == null) {
            return 0;
        }
        return this.m_Fields.length;
    }

    public String[] getFields() {
        return this.m_Fields;
    }

    public String getField(int index) throws IndexOutOfBoundsException {
        return this.m_Fields[index];
    }

    public int getFieldId(int index) throws IndexOutOfBoundsException {
        return this.m_FieldIds[index];
    }

    public void setFieldLevel(int level) {
        this.m_FieldLevel = level;
    }

    public void addField(int id, String text) {
        this.m_FieldIds[this.m_FieldCount] = id;
        this.m_Fields[this.m_FieldCount] = text;
        ++this.m_FieldCount;
    }

    @Override
    public void writeData(DataOutput dout) throws IOException {
        dout.write(this.getMessage());
    }

    @Override
    public void readData(DataInput din) throws IOException {
        int byteCount = 0;
        int subCode = din.readUnsignedByte();
        if (subCode != 14) {
            throw new IOException("Invalid sub code");
        }
        this.m_FieldLevel = din.readUnsignedByte();
        this.m_Conformity = din.readUnsignedByte();
        this.m_MoreFollows = din.readUnsignedByte() == 255;
        this.m_NextFieldId = din.readUnsignedByte();
        this.m_FieldCount = din.readUnsignedByte();
        byteCount = 6;
        if (this.m_FieldCount > 0) {
            this.m_Fields = new String[this.m_FieldCount];
            this.m_FieldIds = new int[this.m_FieldCount];
            int i = 0;
            while (i < this.m_FieldCount) {
                this.m_FieldIds[i] = din.readUnsignedByte();
                int len = din.readUnsignedByte();
                byte[] data = new byte[len];
                din.readFully(data);
                this.m_Fields[i] = new String(data);
                byteCount += 2 + len;
                ++i;
            }
            this.setDataLength(byteCount);
            return;
        }
        this.setDataLength(byteCount);
    }

    @Override
    public byte[] getMessage() {
        int size = 6;
        int i = 0;
        while (i < this.m_FieldCount) {
            ++size;
            ++size;
            size += this.m_Fields[i].length();
            ++i;
        }
        byte[] result = new byte[size];
        int offset = 0;
        result[offset++] = 14;
        result[offset++] = (byte)this.m_FieldLevel;
        result[offset++] = (byte)this.m_Conformity;
        result[offset++] = (byte)(this.m_MoreFollows ? 255 : 0);
        result[offset++] = (byte)this.m_NextFieldId;
        result[offset++] = (byte)this.m_FieldCount;
        int i2 = 0;
        while (i2 < this.m_FieldCount) {
            result[offset++] = (byte)this.m_FieldIds[i2];
            result[offset++] = (byte)this.m_Fields[i2].length();
            System.arraycopy(this.m_Fields[i2].getBytes(), 0, result, offset, this.m_Fields[i2].length());
            offset += this.m_Fields[i2].length();
            ++i2;
        }
        return result;
    }
}

