/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.msg;

import com.ghgande.j2mod.modbus.ModbusCoupler;
import com.ghgande.j2mod.modbus.msg.ModbusRequest;
import com.ghgande.j2mod.modbus.msg.ModbusResponse;
import com.ghgande.j2mod.modbus.msg.ReadMultipleRegistersResponse;
import com.ghgande.j2mod.modbus.procimg.IllegalAddressException;
import com.ghgande.j2mod.modbus.procimg.ProcessImage;
import com.ghgande.j2mod.modbus.procimg.Register;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class ReadMultipleRegistersRequest
extends ModbusRequest {
    private int m_Reference;
    private int m_WordCount;

    public ReadMultipleRegistersRequest() {
        this.setFunctionCode(3);
        this.setDataLength(4);
    }

    public ReadMultipleRegistersRequest(int ref, int count) {
        this.setFunctionCode(3);
        this.setDataLength(4);
        this.setReference(ref);
        this.setWordCount(count);
    }

    @Override
    public ModbusResponse getResponse() {
        ReadMultipleRegistersResponse response = null;
        response = new ReadMultipleRegistersResponse();
        response.setUnitID(this.getUnitID());
        response.setHeadless(this.isHeadless());
        if (!this.isHeadless()) {
            response.setProtocolID(this.getProtocolID());
            response.setTransactionID(this.getTransactionID());
        }
        return response;
    }

    @Override
    public ModbusResponse createResponse() {
        ReadMultipleRegistersResponse response = null;
        Register[] regs = null;
        ProcessImage procimg = ModbusCoupler.getReference().getProcessImage();
        try {
            regs = procimg.getRegisterRange(this.getReference(), this.getWordCount());
        }
        catch (IllegalAddressException e) {
            return this.createExceptionResponse(2);
        }
        response = (ReadMultipleRegistersResponse)this.getResponse();
        response.setRegisters(regs);
        return response;
    }

    public void setReference(int ref) {
        this.m_Reference = ref;
    }

    public int getReference() {
        return this.m_Reference;
    }

    public void setWordCount(int count) {
        this.m_WordCount = count;
    }

    public int getWordCount() {
        return this.m_WordCount;
    }

    @Override
    public void writeData(DataOutput dout) throws IOException {
        dout.writeShort(this.m_Reference);
        dout.writeShort(this.m_WordCount);
    }

    @Override
    public void readData(DataInput din) throws IOException {
        this.m_Reference = din.readUnsignedShort();
        this.m_WordCount = din.readUnsignedShort();
    }

    @Override
    public byte[] getMessage() {
        byte[] result = new byte[]{(byte)(this.m_Reference >> 8 & 0xFF), (byte)(this.m_Reference & 0xFF), (byte)(this.m_WordCount >> 8 & 0xFF), (byte)(this.m_WordCount & 0xFF)};
        return result;
    }
}

