/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.msg;

import com.ghgande.j2mod.modbus.ModbusCoupler;
import com.ghgande.j2mod.modbus.io.NonWordDataHandler;
import com.ghgande.j2mod.modbus.msg.ModbusRequest;
import com.ghgande.j2mod.modbus.msg.ModbusResponse;
import com.ghgande.j2mod.modbus.msg.ReadWriteMultipleResponse;
import com.ghgande.j2mod.modbus.procimg.IllegalAddressException;
import com.ghgande.j2mod.modbus.procimg.InputRegister;
import com.ghgande.j2mod.modbus.procimg.ProcessImage;
import com.ghgande.j2mod.modbus.procimg.Register;
import com.ghgande.j2mod.modbus.procimg.SimpleInputRegister;
import com.ghgande.j2mod.modbus.procimg.SimpleRegister;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class ReadWriteMultipleRequest
extends ModbusRequest {
    private NonWordDataHandler m_NonWordDataHandler;
    private int m_ReadReference;
    private int m_ReadCount;
    private int m_WriteReference;
    private int m_WriteCount;
    private Register[] m_WriteRegisters;

    @Override
    public ModbusResponse getResponse() {
        ReadWriteMultipleResponse response = null;
        response = new ReadWriteMultipleResponse();
        response.setHeadless(this.isHeadless());
        if (!this.isHeadless()) {
            response.setTransactionID(this.getTransactionID());
            response.setProtocolID(this.getProtocolID());
        }
        response.setUnitID(this.getUnitID());
        response.setFunctionCode(this.getFunctionCode());
        return response;
    }

    @Override
    public ModbusResponse createResponse() {
        ReadWriteMultipleResponse response = null;
        InputRegister[] readRegs = null;
        Register[] writeRegs = null;
        ProcessImage procimg = ModbusCoupler.getReference().getProcessImage();
        try {
            readRegs = procimg.getRegisterRange(this.getReadReference(), this.getReadWordCount());
            InputRegister[] dummy = new InputRegister[readRegs.length];
            int i = 0;
            while (i < readRegs.length) {
                dummy[i] = new SimpleInputRegister(readRegs[i].getValue());
                ++i;
            }
            readRegs = dummy;
            writeRegs = procimg.getRegisterRange(this.getWriteReference(), this.getWriteWordCount());
            i = 0;
            while (i < writeRegs.length) {
                writeRegs[i].setValue(this.getRegister(i).getValue());
                ++i;
            }
        }
        catch (IllegalAddressException e) {
            return this.createExceptionResponse(2);
        }
        response = (ReadWriteMultipleResponse)this.getResponse();
        response.setRegisters(readRegs);
        return response;
    }

    public void setReadReference(int ref) {
        this.m_ReadReference = ref;
    }

    public int getReadReference() {
        return this.m_ReadReference;
    }

    public void setWriteReference(int ref) {
        this.m_WriteReference = ref;
    }

    public int getWriteReference() {
        return this.m_WriteReference;
    }

    public void setRegisters(Register[] registers) {
        this.m_WriteRegisters = registers;
        this.m_WriteCount = registers != null ? registers.length : 0;
    }

    public Register[] getRegisters() {
        return this.m_WriteRegisters;
    }

    public Register getRegister(int index) throws IndexOutOfBoundsException {
        if (index < 0) {
            throw new IndexOutOfBoundsException(String.valueOf(index) + " < 0");
        }
        if (index >= this.getWriteWordCount()) {
            throw new IndexOutOfBoundsException(String.valueOf(index) + " > " + this.getWriteWordCount());
        }
        return this.m_WriteRegisters[index];
    }

    public int getReadRegisterValue(int index) throws IndexOutOfBoundsException {
        return this.getRegister(index).toUnsignedShort();
    }

    public int getByteCount() {
        return this.getWriteWordCount() * 2;
    }

    public int getWriteWordCount() {
        return this.m_WriteCount;
    }

    public void setWriteWordCount(int count) {
        this.m_WriteCount = count;
    }

    public int getReadWordCount() {
        return this.m_ReadCount;
    }

    public void setReadWordCount(int count) {
        this.m_ReadCount = count;
    }

    public void setNonWordDataHandler(NonWordDataHandler dhandler) {
        this.m_NonWordDataHandler = dhandler;
    }

    public NonWordDataHandler getNonWordDataHandler() {
        return this.m_NonWordDataHandler;
    }

    @Override
    public void writeData(DataOutput dout) throws IOException {
        dout.write(this.getMessage());
    }

    @Override
    public void readData(DataInput input) throws IOException {
        this.m_ReadReference = input.readShort();
        this.m_ReadCount = input.readShort();
        this.m_WriteReference = input.readShort();
        this.m_WriteCount = input.readUnsignedShort();
        int byteCount = input.readUnsignedByte();
        if (this.m_NonWordDataHandler == null) {
            byte[] buffer = new byte[byteCount];
            input.readFully(buffer, 0, byteCount);
            int offset = 0;
            this.m_WriteRegisters = new Register[this.m_WriteCount];
            int register = 0;
            while (register < this.m_WriteCount) {
                this.m_WriteRegisters[register] = new SimpleRegister(buffer[offset], buffer[offset + 1]);
                offset += 2;
                ++register;
            }
        } else {
            this.m_NonWordDataHandler.readData(input, this.m_WriteReference, this.m_WriteCount);
        }
    }

    @Override
    public byte[] getMessage() {
        byte[] results = new byte[9 + 2 * this.getWriteWordCount()];
        results[0] = (byte)(this.m_ReadReference >> 8);
        results[1] = (byte)(this.m_ReadReference & 0xFF);
        results[2] = (byte)(this.m_ReadCount >> 8);
        results[3] = (byte)(this.m_ReadCount & 0xFF);
        results[4] = (byte)(this.m_WriteReference >> 8);
        results[5] = (byte)(this.m_WriteReference & 0xFF);
        results[6] = (byte)(this.m_WriteCount >> 8);
        results[7] = (byte)(this.m_WriteCount & 0xFF);
        results[8] = (byte)(this.m_WriteCount * 2);
        int offset = 9;
        int i = 0;
        while (i < this.m_WriteCount) {
            Register reg = this.getRegister(i);
            byte[] bytes = reg.toBytes();
            results[offset++] = bytes[0];
            results[offset++] = bytes[1];
            ++i;
        }
        return results;
    }

    public ReadWriteMultipleRequest(int unit, int readRef, int readCount, int writeRef, int writeCount) {
        this.setUnitID(unit);
        this.setFunctionCode(23);
        this.setDataLength(9 + writeCount * 2);
        this.m_ReadReference = readRef;
        this.m_ReadCount = readCount;
        this.m_WriteReference = writeRef;
        this.m_WriteCount = writeCount;
        this.m_WriteRegisters = new Register[writeCount];
        int i = 0;
        while (i < writeCount) {
            this.m_WriteRegisters[i] = new SimpleRegister(0);
            ++i;
        }
    }

    public ReadWriteMultipleRequest(int unit) {
        this.setUnitID(unit);
        this.setFunctionCode(23);
        this.setDataLength(9);
    }

    public ReadWriteMultipleRequest() {
        this.setFunctionCode(23);
        this.setDataLength(9);
    }
}

