/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.msg;

import com.ghgande.j2mod.modbus.msg.ModbusResponse;
import com.ghgande.j2mod.modbus.procimg.InputRegister;
import com.ghgande.j2mod.modbus.procimg.Register;
import com.ghgande.j2mod.modbus.procimg.SimpleRegister;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class ReadWriteMultipleResponse
extends ModbusResponse {
    private int m_ByteCount;
    private InputRegister[] m_Registers;

    public int getByteCount() {
        return this.m_ByteCount;
    }

    public int getWordCount() {
        return this.m_ByteCount / 2;
    }

    public InputRegister getRegister(int index) {
        if (this.m_Registers == null) {
            throw new IndexOutOfBoundsException("No registers defined!");
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException("Negative index: " + index);
        }
        if (index >= this.getWordCount()) {
            throw new IndexOutOfBoundsException(String.valueOf(index) + " > " + this.getWordCount());
        }
        return this.m_Registers[index];
    }

    public int getRegisterValue(int index) throws IndexOutOfBoundsException {
        return this.getRegister(index).toUnsignedShort();
    }

    public InputRegister[] getRegisters() {
        return this.m_Registers;
    }

    public void setRegisters(InputRegister[] registers) {
        this.m_ByteCount = registers.length * 2 + 1;
        this.setDataLength(this.m_ByteCount);
        this.m_Registers = registers;
    }

    @Override
    public void writeData(DataOutput dout) throws IOException {
        dout.writeByte(this.m_ByteCount);
        int k = 0;
        while (k < this.getWordCount()) {
            dout.write(this.m_Registers[k].toBytes());
            ++k;
        }
    }

    @Override
    public void readData(DataInput din) throws IOException {
        this.m_ByteCount = din.readUnsignedByte();
        this.m_Registers = new Register[this.getWordCount()];
        int k = 0;
        while (k < this.getWordCount()) {
            this.m_Registers[k] = new SimpleRegister(din.readByte(), din.readByte());
            ++k;
        }
        this.setDataLength(this.m_ByteCount + 1);
    }

    @Override
    public byte[] getMessage() {
        byte[] result = null;
        result = new byte[this.getWordCount() * 2 + 1];
        int offset = 0;
        result[offset++] = (byte)this.m_ByteCount;
        int i = 0;
        while (i < this.m_Registers.length) {
            byte[] data = this.m_Registers[i].toBytes();
            result[offset++] = data[0];
            result[offset++] = data[1];
            ++i;
        }
        return result;
    }

    public ReadWriteMultipleResponse(InputRegister[] registers) {
        this.setFunctionCode(23);
        this.setDataLength(registers.length * 2 + 1);
        this.m_Registers = registers;
        this.m_ByteCount = registers.length * 2 + 1;
    }

    public ReadWriteMultipleResponse(int count) {
        this.setFunctionCode(23);
        this.setDataLength(count * 2 + 1);
        this.m_Registers = new InputRegister[count];
        this.m_ByteCount = count * 2 + 1;
    }

    public ReadWriteMultipleResponse() {
        this.setFunctionCode(23);
    }
}

