/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.msg;

import com.ghgande.j2mod.modbus.Modbus;
import com.ghgande.j2mod.modbus.ModbusCoupler;
import com.ghgande.j2mod.modbus.msg.ModbusRequest;
import com.ghgande.j2mod.modbus.msg.ModbusResponse;
import com.ghgande.j2mod.modbus.msg.WriteCoilResponse;
import com.ghgande.j2mod.modbus.procimg.DigitalOut;
import com.ghgande.j2mod.modbus.procimg.IllegalAddressException;
import com.ghgande.j2mod.modbus.procimg.ProcessImage;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class WriteCoilRequest
extends ModbusRequest {
    private int m_Reference;
    private boolean m_Coil;

    public WriteCoilRequest() {
        this.setFunctionCode(5);
        this.setDataLength(4);
    }

    public WriteCoilRequest(int ref, boolean b) {
        this.setFunctionCode(5);
        this.setDataLength(4);
        this.setReference(ref);
        this.setCoil(b);
    }

    @Override
    public ModbusResponse getResponse() {
        WriteCoilResponse response = new WriteCoilResponse();
        response.setHeadless(this.isHeadless());
        if (!this.isHeadless()) {
            response.setProtocolID(this.getProtocolID());
            response.setTransactionID(this.getTransactionID());
        }
        response.setFunctionCode(this.getFunctionCode());
        response.setUnitID(this.getUnitID());
        return response;
    }

    @Override
    public ModbusResponse createResponse() {
        WriteCoilResponse response = null;
        DigitalOut dout = null;
        ProcessImage procimg = ModbusCoupler.getReference().getProcessImage();
        try {
            dout = procimg.getDigitalOut(this.getReference());
            dout.set(this.getCoil());
        }
        catch (IllegalAddressException iaex) {
            return this.createExceptionResponse(2);
        }
        response = (WriteCoilResponse)this.getResponse();
        response.setReference(this.getReference());
        response.setCoil(this.getCoil());
        return response;
    }

    public void setReference(int ref) {
        this.m_Reference = ref;
    }

    public int getReference() {
        return this.m_Reference;
    }

    public void setCoil(boolean b) {
        this.m_Coil = b;
    }

    public boolean getCoil() {
        return this.m_Coil;
    }

    @Override
    public void writeData(DataOutput dout) throws IOException {
        dout.writeShort(this.m_Reference);
        if (this.m_Coil) {
            dout.write(Modbus.COIL_ON_BYTES, 0, 2);
        } else {
            dout.write(Modbus.COIL_OFF_BYTES, 0, 2);
        }
    }

    @Override
    public void readData(DataInput din) throws IOException {
        this.m_Reference = din.readUnsignedShort();
        this.m_Coil = din.readByte() == -1;
        din.readByte();
    }

    @Override
    public byte[] getMessage() {
        byte[] result = new byte[4];
        result[0] = (byte)(this.m_Reference >> 8 & 0xFF);
        result[1] = (byte)(this.m_Reference & 0xFF);
        if (this.m_Coil) {
            result[2] = Modbus.COIL_ON_BYTES[0];
            result[3] = Modbus.COIL_ON_BYTES[1];
        } else {
            result[2] = Modbus.COIL_OFF_BYTES[0];
            result[3] = Modbus.COIL_OFF_BYTES[1];
        }
        return result;
    }
}

