/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.msg;

import com.ghgande.j2mod.modbus.Modbus;
import com.ghgande.j2mod.modbus.msg.ModbusResponse;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class WriteCoilResponse
extends ModbusResponse {
    private boolean m_Coil = false;
    private int m_Reference;

    public WriteCoilResponse() {
        this.setFunctionCode(5);
        this.setDataLength(4);
    }

    public WriteCoilResponse(int reference, boolean b) {
        this.setFunctionCode(5);
        this.setDataLength(4);
        this.setReference(reference);
        this.setCoil(b);
    }

    public void setCoil(boolean b) {
        this.m_Coil = b;
    }

    public boolean getCoil() {
        return this.m_Coil;
    }

    public int getReference() {
        return this.m_Reference;
    }

    public void setReference(int ref) {
        this.m_Reference = ref;
    }

    @Override
    public void writeData(DataOutput dout) throws IOException {
        byte[] data = this.getMessage();
        if (data == null) {
            return;
        }
        dout.write(data);
    }

    @Override
    public void readData(DataInput din) throws IOException {
        byte[] data = new byte[4];
        din.readFully(data);
        this.setReference(data[0] << 8 | data[1] & 0xFF);
        this.setCoil(data[2] == -1);
        this.setDataLength(4);
    }

    @Override
    public byte[] getMessage() {
        byte[] result = new byte[4];
        result[0] = (byte)(this.m_Reference >> 8 & 0xFF);
        result[1] = (byte)(this.m_Reference & 0xFF);
        if (this.m_Coil) {
            result[2] = Modbus.COIL_ON_BYTES[0];
            result[3] = Modbus.COIL_ON_BYTES[1];
        } else {
            result[2] = Modbus.COIL_OFF_BYTES[0];
            result[3] = Modbus.COIL_OFF_BYTES[1];
        }
        return result;
    }
}

