/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.msg;

import com.ghgande.j2mod.modbus.ModbusCoupler;
import com.ghgande.j2mod.modbus.msg.ModbusRequest;
import com.ghgande.j2mod.modbus.msg.ModbusResponse;
import com.ghgande.j2mod.modbus.msg.WriteFileRecordResponse;
import com.ghgande.j2mod.modbus.procimg.File;
import com.ghgande.j2mod.modbus.procimg.IllegalAddressException;
import com.ghgande.j2mod.modbus.procimg.ProcessImage;
import com.ghgande.j2mod.modbus.procimg.Record;
import com.ghgande.j2mod.modbus.procimg.Register;
import com.ghgande.j2mod.modbus.procimg.SimpleRegister;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class WriteFileRecordRequest
extends ModbusRequest {
    private int m_ByteCount;
    private RecordRequest[] m_Records;

    public int getRequestSize() {
        if (this.m_Records == null) {
            return 1;
        }
        int size = 1;
        int i = 0;
        while (i < this.m_Records.length) {
            size += this.m_Records[i].getRequestSize();
            ++i;
        }
        return size;
    }

    public int getRequestCount() {
        if (this.m_Records == null) {
            return 0;
        }
        return this.m_Records.length;
    }

    public RecordRequest getRecord(int index) {
        return this.m_Records[index];
    }

    public void addRequest(RecordRequest request) {
        if (request.getRequestSize() + this.getRequestSize() > 248) {
            throw new IllegalArgumentException();
        }
        if (this.m_Records == null) {
            this.m_Records = new RecordRequest[1];
        } else {
            RecordRequest[] old = this.m_Records;
            this.m_Records = new RecordRequest[old.length + 1];
            System.arraycopy(old, 0, this.m_Records, 0, old.length);
        }
        this.m_Records[this.m_Records.length - 1] = request;
        this.setDataLength(this.getRequestSize());
    }

    @Override
    public ModbusResponse getResponse() {
        WriteFileRecordResponse response = null;
        response = new WriteFileRecordResponse();
        response.setHeadless(this.isHeadless());
        if (!this.isHeadless()) {
            response.setTransactionID(this.getTransactionID());
            response.setProtocolID(this.getProtocolID());
        }
        response.setUnitID(this.getUnitID());
        response.setFunctionCode(this.getFunctionCode());
        return response;
    }

    @Override
    public ModbusResponse createResponse() {
        WriteFileRecordResponse response = null;
        response = (WriteFileRecordResponse)this.getResponse();
        ProcessImage procimg = ModbusCoupler.getReference().getProcessImage();
        try {
            int i = 0;
            while (i < this.getRequestCount()) {
                RecordRequest recordRequest = this.getRecord(i);
                if (recordRequest.getFileNumber() < 0 || recordRequest.getFileNumber() >= procimg.getFileCount()) {
                    return this.createExceptionResponse(2);
                }
                File file = procimg.getFileByNumber(recordRequest.getFileNumber());
                if (recordRequest.getRecordNumber() < 0 || recordRequest.getRecordNumber() >= file.getRecordCount()) {
                    return this.createExceptionResponse(2);
                }
                Record record = file.getRecord(recordRequest.getRecordNumber());
                int registers = recordRequest.getWordCount();
                if (record == null && registers != 0) {
                    return this.createExceptionResponse(2);
                }
                short[] data = new short[registers];
                int j = 0;
                while (j < registers) {
                    Register register = record.getRegister(j);
                    if (register == null) {
                        return this.createExceptionResponse(2);
                    }
                    register.setValue(recordRequest.getRegister(j).getValue());
                    data[j] = recordRequest.getRegister(j).toShort();
                    ++j;
                }
                WriteFileRecordResponse writeFileRecordResponse = response;
                writeFileRecordResponse.getClass();
                WriteFileRecordResponse.RecordResponse recordResponse = new WriteFileRecordResponse.RecordResponse(writeFileRecordResponse, file.getFileNumber(), record.getRecordNumber(), data);
                response.addResponse(recordResponse);
                ++i;
            }
        }
        catch (IllegalAddressException e) {
            return this.createExceptionResponse(2);
        }
        return response;
    }

    @Override
    public void writeData(DataOutput dout) throws IOException {
        dout.write(this.getMessage());
    }

    @Override
    public void readData(DataInput din) throws IOException {
        this.m_ByteCount = din.readUnsignedByte();
        this.m_Records = new RecordRequest[0];
        int offset = 1;
        while (offset + 7 < this.m_ByteCount) {
            int function = din.readUnsignedByte();
            int file = din.readUnsignedShort();
            int record = din.readUnsignedShort();
            int count = din.readUnsignedShort();
            offset += 7;
            if (function != 6) {
                throw new IOException();
            }
            if (record < 0 || record >= 10000) {
                throw new IOException();
            }
            if (count < 0 || count >= 126) {
                throw new IOException();
            }
            short[] registers = new short[count];
            int j = 0;
            while (j < count) {
                registers[j] = din.readShort();
                offset += 2;
                ++j;
            }
            RecordRequest[] dummy = new RecordRequest[this.m_Records.length + 1];
            if (this.m_Records.length > 0) {
                System.arraycopy(this.m_Records, 0, dummy, 0, this.m_Records.length);
            }
            this.m_Records = dummy;
            this.m_Records[this.m_Records.length - 1] = new RecordRequest(file, record, registers);
        }
    }

    @Override
    public byte[] getMessage() {
        byte[] results = new byte[this.getRequestSize()];
        results[0] = (byte)(this.getRequestSize() - 1);
        int offset = 1;
        int i = 0;
        while (i < this.m_Records.length) {
            this.m_Records[i].getRequest(results, offset);
            offset += this.m_Records[i].getRequestSize();
            ++i;
        }
        return results;
    }

    public WriteFileRecordRequest() {
        this.setFunctionCode(21);
        this.setDataLength(1);
    }

    public class RecordRequest {
        private int m_FileNumber;
        private int m_RecordNumber;
        private int m_WordCount;
        private byte[] m_Data;

        public int getFileNumber() {
            return this.m_FileNumber;
        }

        public int getRecordNumber() {
            return this.m_RecordNumber;
        }

        public int getWordCount() {
            return this.m_WordCount;
        }

        public SimpleRegister getRegister(int register) {
            if (register < 0 || register >= this.m_WordCount) {
                throw new IllegalAddressException("0 <= " + register + " < " + this.m_WordCount);
            }
            byte b1 = this.m_Data[register * 2];
            byte b2 = this.m_Data[register * 2 + 1];
            SimpleRegister result = new SimpleRegister(b1, b2);
            return result;
        }

        public int getRequestSize() {
            return 7 + this.m_WordCount * 2;
        }

        public void getRequest(byte[] request, int offset) {
            request[offset++] = 6;
            request[offset++] = (byte)(this.m_FileNumber >> 8);
            request[offset++] = (byte)(this.m_FileNumber & 0xFF);
            request[offset++] = (byte)(this.m_RecordNumber >> 8);
            request[offset++] = (byte)(this.m_RecordNumber & 0xFF);
            request[offset++] = (byte)(this.m_WordCount >> 8);
            request[offset++] = (byte)(this.m_WordCount & 0xFF);
            System.arraycopy(this.m_Data, 0, request, offset, this.m_Data.length);
        }

        public byte[] getRequest() {
            byte[] request = new byte[7 + 2 * this.m_WordCount];
            this.getRequest(request, 0);
            return request;
        }

        public RecordRequest(int file, int record, short[] values) {
            this.m_FileNumber = file;
            this.m_RecordNumber = record;
            this.m_WordCount = values.length;
            this.m_Data = new byte[this.m_WordCount * 2];
            int offset = 0;
            int i = 0;
            while (i < this.m_WordCount) {
                this.m_Data[offset++] = (byte)(values[i] >> 8);
                this.m_Data[offset++] = (byte)(values[i] & 0xFF);
                ++i;
            }
        }
    }
}

