/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.msg;

import com.ghgande.j2mod.modbus.msg.ModbusResponse;
import com.ghgande.j2mod.modbus.procimg.SimpleRegister;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class WriteFileRecordResponse
extends ModbusResponse {
    private int m_ByteCount;
    private RecordResponse[] m_Records;

    public int getResponseSize() {
        if (this.m_Records == null) {
            return 1;
        }
        int size = 1;
        int i = 0;
        while (i < this.m_Records.length) {
            size += this.m_Records[i].getResponseSize();
            ++i;
        }
        return size;
    }

    public int getRequestCount() {
        if (this.m_Records == null) {
            return 0;
        }
        return this.m_Records.length;
    }

    public RecordResponse getRecord(int index) {
        return this.m_Records[index];
    }

    public void addResponse(RecordResponse response) {
        if (response.getResponseSize() + this.getResponseSize() > 248) {
            throw new IllegalArgumentException();
        }
        if (this.m_Records == null) {
            this.m_Records = new RecordResponse[1];
        } else {
            RecordResponse[] old = this.m_Records;
            this.m_Records = new RecordResponse[old.length + 1];
            System.arraycopy(old, 0, this.m_Records, 0, old.length);
        }
        this.m_Records[this.m_Records.length - 1] = response;
        this.setDataLength(this.getResponseSize());
    }

    @Override
    public void writeData(DataOutput dout) throws IOException {
        dout.write(this.getMessage());
    }

    @Override
    public void readData(DataInput din) throws IOException {
        this.m_ByteCount = din.readUnsignedByte();
        this.m_Records = new RecordResponse[0];
        int offset = 1;
        while (offset + 7 < this.m_ByteCount) {
            int function = din.readUnsignedByte();
            int file = din.readUnsignedShort();
            int record = din.readUnsignedShort();
            int count = din.readUnsignedShort();
            offset += 7;
            if (function != 6) {
                throw new IOException();
            }
            if (record < 0 || record >= 10000) {
                throw new IOException();
            }
            if (count < 0 || count >= 126) {
                throw new IOException();
            }
            short[] registers = new short[count];
            int j = 0;
            while (j < count) {
                registers[j] = din.readShort();
                offset += 2;
                ++j;
            }
            RecordResponse[] dummy = new RecordResponse[this.m_Records.length + 1];
            if (this.m_Records.length > 0) {
                System.arraycopy(this.m_Records, 0, dummy, 0, this.m_Records.length);
            }
            this.m_Records = dummy;
            this.m_Records[this.m_Records.length - 1] = new RecordResponse(file, record, registers);
        }
    }

    @Override
    public byte[] getMessage() {
        byte[] results = new byte[this.getResponseSize()];
        results[0] = (byte)(this.getResponseSize() - 1);
        int offset = 1;
        int i = 0;
        while (i < this.m_Records.length) {
            this.m_Records[i].getResponse(results, offset);
            offset += this.m_Records[i].getResponseSize();
            ++i;
        }
        return results;
    }

    public WriteFileRecordResponse() {
        this.setFunctionCode(21);
        this.setDataLength(7);
    }

    public class RecordResponse {
        private int m_FileNumber;
        private int m_RecordNumber;
        private int m_WordCount;
        private byte[] m_Data;

        public int getFileNumber() {
            return this.m_FileNumber;
        }

        public int getRecordNumber() {
            return this.m_RecordNumber;
        }

        public int getWordCount() {
            return this.m_WordCount;
        }

        public SimpleRegister getRegister(int register) {
            if (register < 0 || register >= this.m_WordCount) {
                throw new IndexOutOfBoundsException("0 <= " + register + " < " + this.m_WordCount);
            }
            byte b1 = this.m_Data[register * 2];
            byte b2 = this.m_Data[register * 2 + 1];
            SimpleRegister result = new SimpleRegister(b1, b2);
            return result;
        }

        public int getResponseSize() {
            return 7 + this.m_WordCount * 2;
        }

        public void getResponse(byte[] response, int offset) {
            response[offset++] = 6;
            response[offset++] = (byte)(this.m_FileNumber >> 8);
            response[offset++] = (byte)(this.m_FileNumber & 0xFF);
            response[offset++] = (byte)(this.m_RecordNumber >> 8);
            response[offset++] = (byte)(this.m_RecordNumber & 0xFF);
            response[offset++] = (byte)(this.m_WordCount >> 8);
            response[offset++] = (byte)(this.m_WordCount & 0xFF);
            System.arraycopy(this.m_Data, 0, response, offset, this.m_Data.length);
        }

        public byte[] getResponse() {
            byte[] response = new byte[7 + 2 * this.m_WordCount];
            this.getResponse(response, 0);
            return response;
        }

        public RecordResponse(int file, int record, short[] values) {
            this.m_FileNumber = file;
            this.m_RecordNumber = record;
            this.m_WordCount = values.length;
            this.m_Data = new byte[this.m_WordCount * 2];
            int offset = 0;
            int i = 0;
            while (i < this.m_WordCount) {
                this.m_Data[offset++] = (byte)(values[i] >> 8);
                this.m_Data[offset++] = (byte)(values[i] & 0xFF);
                ++i;
            }
        }
    }
}

