/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.msg;

import com.ghgande.j2mod.modbus.ModbusCoupler;
import com.ghgande.j2mod.modbus.msg.ModbusRequest;
import com.ghgande.j2mod.modbus.msg.ModbusResponse;
import com.ghgande.j2mod.modbus.msg.WriteMultipleCoilsResponse;
import com.ghgande.j2mod.modbus.procimg.DigitalOut;
import com.ghgande.j2mod.modbus.procimg.IllegalAddressException;
import com.ghgande.j2mod.modbus.procimg.ProcessImage;
import com.ghgande.j2mod.modbus.util.BitVector;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class WriteMultipleCoilsRequest
extends ModbusRequest {
    private int m_Reference;
    private BitVector m_Coils;

    @Override
    public ModbusResponse getResponse() {
        WriteMultipleCoilsResponse response = new WriteMultipleCoilsResponse();
        response.setHeadless(this.isHeadless());
        if (!this.isHeadless()) {
            response.setProtocolID(this.getProtocolID());
            response.setTransactionID(this.getTransactionID());
        }
        response.setFunctionCode(this.getFunctionCode());
        response.setUnitID(this.getUnitID());
        return response;
    }

    @Override
    public ModbusResponse createResponse() {
        WriteMultipleCoilsResponse response = null;
        DigitalOut[] douts = null;
        ProcessImage procimg = ModbusCoupler.getReference().getProcessImage();
        try {
            douts = procimg.getDigitalOutRange(this.m_Reference, this.m_Coils.size());
            int i = 0;
            while (i < douts.length) {
                douts[i].set(this.m_Coils.getBit(i));
                ++i;
            }
        }
        catch (IllegalAddressException iaex) {
            return this.createExceptionResponse(2);
        }
        response = (WriteMultipleCoilsResponse)this.getResponse();
        response.setBitCount(this.m_Coils.size());
        response.setReference(this.m_Reference);
        return response;
    }

    public void setReference(int ref) {
        this.m_Reference = ref;
    }

    public int getReference() {
        return this.m_Reference;
    }

    public int getBitCount() {
        if (this.m_Coils == null) {
            return 0;
        }
        return this.m_Coils.size();
    }

    public int getByteCount() {
        return this.m_Coils.byteSize();
    }

    public boolean getCoilStatus(int index) throws IndexOutOfBoundsException {
        return this.m_Coils.getBit(index);
    }

    public void setCoilStatus(int index, boolean b) throws IndexOutOfBoundsException {
        this.m_Coils.setBit(index, b);
    }

    public BitVector getCoils() {
        return this.m_Coils;
    }

    public void setCoils(BitVector bv) {
        this.m_Coils = bv;
    }

    @Override
    public void writeData(DataOutput dout) throws IOException {
        dout.writeShort(this.m_Reference);
        dout.writeShort(this.m_Coils.size());
        dout.writeByte(this.m_Coils.byteSize());
        dout.write(this.m_Coils.getBytes());
    }

    @Override
    public void readData(DataInput din) throws IOException {
        this.m_Reference = din.readUnsignedShort();
        int bitcount = din.readUnsignedShort();
        int coilBytes = din.readUnsignedByte();
        byte[] data = new byte[coilBytes];
        int k = 0;
        while (k < coilBytes) {
            data[k] = din.readByte();
            ++k;
        }
        this.m_Coils = BitVector.createBitVector(data, bitcount);
        this.setDataLength(coilBytes + 5);
    }

    @Override
    public byte[] getMessage() {
        int len = this.m_Coils.byteSize() + 5;
        byte[] result = new byte[len];
        result[0] = (byte)(this.m_Reference >> 8 & 0xFF);
        result[1] = (byte)(this.m_Reference & 0xFF);
        result[2] = (byte)(this.m_Coils.size() >> 8 & 0xFF);
        result[3] = (byte)(this.m_Coils.size() & 0xFF);
        result[4] = (byte)this.m_Coils.byteSize();
        System.arraycopy(this.m_Coils.getBytes(), 0, result, 5, this.m_Coils.byteSize());
        return result;
    }

    public WriteMultipleCoilsRequest(int ref, BitVector bv) {
        this.setFunctionCode(15);
        this.setDataLength(bv.byteSize() + 5);
        this.setReference(ref);
        this.m_Coils = bv;
    }

    public WriteMultipleCoilsRequest(int ref, int count) {
        this.setFunctionCode(15);
        this.setDataLength((count + 7) / 8 + 5);
        this.setReference(ref);
        this.m_Coils = new BitVector(count);
    }

    public WriteMultipleCoilsRequest() {
        this.setFunctionCode(15);
        this.setDataLength(5);
        this.m_Coils = new BitVector(1);
    }
}

