/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.msg;

import com.ghgande.j2mod.modbus.ModbusCoupler;
import com.ghgande.j2mod.modbus.io.NonWordDataHandler;
import com.ghgande.j2mod.modbus.msg.ModbusRequest;
import com.ghgande.j2mod.modbus.msg.ModbusResponse;
import com.ghgande.j2mod.modbus.msg.WriteMultipleRegistersResponse;
import com.ghgande.j2mod.modbus.procimg.IllegalAddressException;
import com.ghgande.j2mod.modbus.procimg.ProcessImage;
import com.ghgande.j2mod.modbus.procimg.Register;
import com.ghgande.j2mod.modbus.procimg.SimpleRegister;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class WriteMultipleRegistersRequest
extends ModbusRequest {
    private int m_Reference;
    private Register[] m_Registers;
    private NonWordDataHandler m_NonWordDataHandler = null;

    @Override
    public ModbusResponse getResponse() {
        WriteMultipleRegistersResponse response = new WriteMultipleRegistersResponse();
        response.setHeadless(this.isHeadless());
        if (!this.isHeadless()) {
            response.setProtocolID(this.getProtocolID());
            response.setTransactionID(this.getTransactionID());
        }
        response.setFunctionCode(this.getFunctionCode());
        response.setUnitID(this.getUnitID());
        return response;
    }

    @Override
    public ModbusResponse createResponse() {
        WriteMultipleRegistersResponse response = null;
        if (this.m_NonWordDataHandler == null) {
            Register[] regs = null;
            ProcessImage procimg = ModbusCoupler.getReference().getProcessImage();
            try {
                regs = procimg.getRegisterRange(this.getReference(), this.getWordCount());
                int i = 0;
                while (i < regs.length) {
                    regs[i].setValue(this.getRegister(i).getValue());
                    ++i;
                }
            }
            catch (IllegalAddressException iaex) {
                return this.createExceptionResponse(2);
            }
            response = (WriteMultipleRegistersResponse)this.getResponse();
            response.setReference(this.getReference());
            response.setWordCount(this.getWordCount());
        } else {
            int result = this.m_NonWordDataHandler.commitUpdate();
            if (result > 0) {
                return this.createExceptionResponse(result);
            }
            response = (WriteMultipleRegistersResponse)this.getResponse();
            response.setReference(this.getReference());
            response.setWordCount(this.m_NonWordDataHandler.getWordCount());
        }
        return response;
    }

    public void setReference(int ref) {
        this.m_Reference = ref;
    }

    public int getReference() {
        return this.m_Reference;
    }

    public void setRegisters(Register[] registers) {
        this.m_Registers = registers;
    }

    public Register[] getRegisters() {
        return this.m_Registers;
    }

    public Register getRegister(int index) throws IndexOutOfBoundsException {
        if (index < 0) {
            throw new IndexOutOfBoundsException(String.valueOf(index) + " < 0");
        }
        if (index >= this.getWordCount()) {
            throw new IndexOutOfBoundsException(String.valueOf(index) + " > " + this.getWordCount());
        }
        return this.m_Registers[index];
    }

    public int getRegisterValue(int index) throws IndexOutOfBoundsException {
        return this.getRegister(index).toUnsignedShort();
    }

    public int getByteCount() {
        return this.getWordCount() * 2;
    }

    public int getWordCount() {
        if (this.m_Registers == null) {
            return 0;
        }
        return this.m_Registers.length;
    }

    public void setNonWordDataHandler(NonWordDataHandler dhandler) {
        this.m_NonWordDataHandler = dhandler;
    }

    public NonWordDataHandler getNonWordDataHandler() {
        return this.m_NonWordDataHandler;
    }

    @Override
    public void writeData(DataOutput output) throws IOException {
        byte[] data = this.getMessage();
        if (data == null) {
            return;
        }
        output.write(data);
    }

    @Override
    public void readData(DataInput input) throws IOException {
        this.m_Reference = input.readShort();
        int registerCount = input.readUnsignedShort();
        int byteCount = input.readUnsignedByte();
        if (this.m_NonWordDataHandler == null) {
            byte[] buffer = new byte[byteCount];
            input.readFully(buffer, 0, byteCount);
            int offset = 0;
            this.m_Registers = new Register[registerCount];
            int register = 0;
            while (register < registerCount) {
                this.m_Registers[register] = new SimpleRegister(buffer[offset], buffer[offset + 1]);
                offset += 2;
                ++register;
            }
        } else {
            this.m_NonWordDataHandler.readData(input, this.m_Reference, registerCount);
        }
    }

    @Override
    public byte[] getMessage() {
        int len = 5;
        if (this.m_Registers != null) {
            len += this.m_Registers.length * 2;
        }
        byte[] result = new byte[len];
        int registerCount = this.m_Registers != null ? this.m_Registers.length : 0;
        result[0] = (byte)(this.m_Reference >> 8 & 0xFF);
        result[1] = (byte)(this.m_Reference & 0xFF);
        result[2] = (byte)(registerCount >> 8 & 0xFF);
        result[3] = (byte)(registerCount & 0xFF);
        result[4] = (byte)(registerCount * 2);
        int offset = 5;
        if (this.m_NonWordDataHandler == null) {
            int i = 0;
            while (i < registerCount) {
                byte[] bytes = this.m_Registers[i].toBytes();
                result[offset++] = bytes[0];
                result[offset++] = bytes[1];
                ++i;
            }
        } else {
            this.m_NonWordDataHandler.prepareData(this.m_Reference, registerCount);
            byte[] bytes = this.m_NonWordDataHandler.getData();
            if (bytes != null) {
                int nonWordBytes = bytes.length;
                if (nonWordBytes > registerCount * 2) {
                    nonWordBytes = registerCount * 2;
                }
                System.arraycopy(bytes, 0, result, offset, nonWordBytes);
            }
        }
        return result;
    }

    public WriteMultipleRegistersRequest(int first, Register[] registers) {
        this.setFunctionCode(16);
        this.setReference(first);
        this.setRegisters(registers);
    }

    public WriteMultipleRegistersRequest() {
        this.setFunctionCode(16);
    }
}

