/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.msg;

import com.ghgande.j2mod.modbus.msg.ModbusResponse;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class WriteMultipleRegistersResponse
extends ModbusResponse {
    private int m_WordCount;
    private int m_Reference;

    public WriteMultipleRegistersResponse() {
        this.setFunctionCode(16);
        this.setDataLength(4);
    }

    public WriteMultipleRegistersResponse(int reference, int wordcount) {
        this.setFunctionCode(16);
        this.setDataLength(4);
        this.m_Reference = reference;
        this.m_WordCount = wordcount;
    }

    public void setReference(int ref) {
        this.m_Reference = ref;
    }

    public int getReference() {
        return this.m_Reference;
    }

    public int getByteCount() {
        return this.m_WordCount * 2;
    }

    public int getWordCount() {
        return this.m_WordCount;
    }

    public void setWordCount(int count) {
        this.m_WordCount = count;
    }

    @Override
    public void writeData(DataOutput dout) throws IOException {
        dout.write(this.getMessage());
    }

    @Override
    public void readData(DataInput din) throws IOException {
        this.setReference(din.readUnsignedShort());
        this.setWordCount(din.readUnsignedShort());
        this.setDataLength(4);
    }

    @Override
    public byte[] getMessage() {
        byte[] result = new byte[]{(byte)(this.m_Reference >> 8 & 0xFF), (byte)(this.m_Reference & 0xFF), (byte)(this.m_WordCount >> 8 & 0xFF), (byte)(this.m_WordCount & 0xFF)};
        return result;
    }
}

