/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.msg;

import com.ghgande.j2mod.modbus.ModbusCoupler;
import com.ghgande.j2mod.modbus.msg.ModbusRequest;
import com.ghgande.j2mod.modbus.msg.ModbusResponse;
import com.ghgande.j2mod.modbus.msg.WriteSingleRegisterResponse;
import com.ghgande.j2mod.modbus.procimg.IllegalAddressException;
import com.ghgande.j2mod.modbus.procimg.ProcessImage;
import com.ghgande.j2mod.modbus.procimg.Register;
import com.ghgande.j2mod.modbus.procimg.SimpleRegister;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class WriteSingleRegisterRequest
extends ModbusRequest {
    private int m_Reference;
    private Register m_Register;

    public WriteSingleRegisterRequest() {
        this.setFunctionCode(6);
        this.setDataLength(4);
    }

    public WriteSingleRegisterRequest(int ref, Register reg) {
        this.setFunctionCode(6);
        this.setDataLength(4);
        this.m_Reference = ref;
        this.m_Register = reg;
    }

    @Override
    public ModbusResponse getResponse() {
        WriteSingleRegisterResponse response = new WriteSingleRegisterResponse();
        response.setHeadless(this.isHeadless());
        if (!this.isHeadless()) {
            response.setProtocolID(this.getProtocolID());
            response.setTransactionID(this.getTransactionID());
        }
        response.setFunctionCode(this.getFunctionCode());
        response.setUnitID(this.getUnitID());
        return response;
    }

    @Override
    public ModbusResponse createResponse() {
        WriteSingleRegisterResponse response = null;
        Register reg = null;
        ProcessImage procimg = ModbusCoupler.getReference().getProcessImage();
        try {
            reg = procimg.getRegister(this.m_Reference);
            reg.setValue(this.m_Register.toBytes());
        }
        catch (IllegalAddressException iaex) {
            return this.createExceptionResponse(2);
        }
        response = (WriteSingleRegisterResponse)this.getResponse();
        return response;
    }

    public void setReference(int ref) {
        this.m_Reference = ref;
    }

    public int getReference() {
        return this.m_Reference;
    }

    public void setRegister(Register reg) {
        this.m_Register = reg;
    }

    public Register getRegister() {
        return this.m_Register;
    }

    @Override
    public void writeData(DataOutput dout) throws IOException {
        dout.writeShort(this.m_Reference);
        dout.write(this.m_Register.toBytes());
    }

    @Override
    public void readData(DataInput din) throws IOException {
        this.m_Reference = din.readUnsignedShort();
        this.m_Register = new SimpleRegister(din.readByte(), din.readByte());
    }

    @Override
    public byte[] getMessage() {
        byte[] result = new byte[]{(byte)(this.m_Reference >> 8 & 0xFF), (byte)(this.m_Reference & 0xFF), (byte)(this.m_Register.getValue() >> 8 & 0xFF), (byte)(this.m_Register.getValue() & 0xFF)};
        return result;
    }
}

