/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.net;

import com.ghgande.j2mod.modbus.net.ModbusListener;
import com.ghgande.j2mod.modbus.net.ModbusSerialListener;
import com.ghgande.j2mod.modbus.net.ModbusTCPListener;
import com.ghgande.j2mod.modbus.net.ModbusUDPListener;
import com.ghgande.j2mod.modbus.util.SerialParameters;

public class ModbusListenerFactory {
    public static ModbusListener createModbusListener(String address) {
        String[] parts = address.split(":");
        if (parts == null || parts.length < 2) {
            throw new IllegalArgumentException("missing connection information");
        }
        if (parts[0].toLowerCase().equals("device")) {
            SerialParameters parms = new SerialParameters();
            parms.setPortName(parts[1]);
            parms.setBaudRate(19200);
            parms.setDatabits(8);
            parms.setEcho(false);
            parms.setParity(0);
            parms.setFlowControlIn(0);
            ModbusSerialListener listener = new ModbusSerialListener(parms);
            if (parts.length > 2) {
                int unit = Integer.parseInt(parts[2]);
                if (unit < 0 || unit > 248) {
                    throw new IllegalArgumentException("illegal unit number");
                }
                listener.setUnit(unit);
            }
            listener.setListening(true);
            Thread result = new Thread(listener);
            result.start();
            return listener;
        }
        if (parts[0].toLowerCase().equals("tcp")) {
            ModbusTCPListener listener = new ModbusTCPListener(5);
            if (parts.length > 2) {
                int port = Integer.parseInt(parts[2]);
                listener.setPort(port);
                if (parts.length > 3) {
                    int unit = Integer.parseInt(parts[3]);
                    listener.setUnit(unit);
                }
            }
            listener.setListening(true);
            Thread result = new Thread(listener);
            result.start();
            return listener;
        }
        if (parts[0].toLowerCase().equals("udp")) {
            ModbusUDPListener listener = new ModbusUDPListener();
            if (parts.length > 2) {
                int port = Integer.parseInt(parts[2]);
                listener.setPort(port);
                if (parts.length > 3) {
                    int unit = Integer.parseInt(parts[3]);
                    listener.setUnit(unit);
                }
            }
            listener.setListening(true);
            Thread result = new Thread(listener);
            result.start();
            return listener;
        }
        throw new IllegalArgumentException("unknown type " + parts[0]);
    }
}

