/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.net;

import com.ghgande.j2mod.modbus.io.ModbusRTUTransport;
import com.ghgande.j2mod.modbus.io.ModbusTCPTransport;
import com.ghgande.j2mod.modbus.io.ModbusTransport;
import com.ghgande.j2mod.modbus.io.ModbusUDPTransport;
import com.ghgande.j2mod.modbus.net.UDPMasterTerminal;
import com.ghgande.j2mod.modbus.util.SerialParameters;
import gnu.io.PortInUseException;
import gnu.io.RXTXPort;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public class ModbusMasterFactory {
    public static ModbusTransport createModbusMaster(String address) {
        String[] parts = address.split(":");
        if (parts == null || parts.length < 2) {
            throw new IllegalArgumentException("missing connection information");
        }
        if (parts[0].toLowerCase().equals("device")) {
            SerialParameters parms = new SerialParameters();
            parms.setPortName(parts[1]);
            parms.setBaudRate(19200);
            parms.setDatabits(8);
            parms.setEcho(false);
            parms.setParity(0);
            parms.setFlowControlIn(0);
            try {
                ModbusRTUTransport transport = new ModbusRTUTransport();
                RXTXPort port = new RXTXPort(parms.getPortName());
                transport.setCommPort(port);
                transport.setEcho(false);
                return transport;
            }
            catch (PortInUseException e) {
                return null;
            }
            catch (IOException e) {
                return null;
            }
        }
        if (parts[0].toLowerCase().equals("tcp")) {
            String hostName = parts[1];
            int port = 502;
            if (parts.length > 2) {
                port = Integer.parseInt(parts[2]);
            }
            try {
                Socket socket = new Socket(hostName, port);
                System.err.println("connecting to " + socket);
                ModbusTCPTransport transport = new ModbusTCPTransport(socket);
                return transport;
            }
            catch (UnknownHostException x) {
                return null;
            }
            catch (IOException e) {
                return null;
            }
        }
        if (parts[0].toLowerCase().equals("udp")) {
            UDPMasterTerminal terminal;
            String hostName = parts[1];
            int port = 502;
            if (parts.length > 2) {
                port = Integer.parseInt(parts[2]);
            }
            try {
                terminal = new UDPMasterTerminal(InetAddress.getByName(hostName));
                terminal.setRemotePort(port);
                terminal.activate();
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
            ModbusUDPTransport transport = terminal.getModbusTransport();
            return transport;
        }
        throw new IllegalArgumentException("unknown type " + parts[0]);
    }
}

